package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 *
 * A structure for the data published on the status bus by the CarouselModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarousel implements Serializable {

    private static final long serialVersionUID = 7037058370873652888L;
    private int position;
    private boolean locked;
    private boolean homingDone;
    private boolean atStandby;
    private double velocity;
    private double current;
    private String filterAtStandbyName;
    private String socketAtStandbyName;
    private int socketAtStandbyID;
    private String filterOnAutochangerName;

    /**
     * To create a new StatusDataPublishedByCarousel with default values.
     */
    public StatusDataPublishedByCarousel() {
        position = 0;
        locked = false;
        homingDone = false;
        filterAtStandbyName = "none";
    }

    public boolean isLocked() {
        return locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getPosition() {
        return position;
    }

    public String getFilterAtStandbyName() {
        return filterAtStandbyName;
    }


    public void setFilterAtStandbyName(String filterInStandbyName) {
        this.filterAtStandbyName = filterInStandbyName;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public String getFilterOnAutochangerName() {
        return filterOnAutochangerName;
    }

    public void setFilterOnAutochangerName(String filterOnAutochangerName) {
        this.filterOnAutochangerName = filterOnAutochangerName;
    }

    public String getSocketAtStandbyName() {
        return socketAtStandbyName;
    }

    public void setSocketAtStandbyName(String socketAtStandbyName) {
        this.socketAtStandbyName = socketAtStandbyName;
    }


    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public double getVelocity() {
        return velocity;
    }

    public void setVelocity(double speed) {
        this.velocity = speed;
    }

    public double getCurrent() {
        return current;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    public int getSocketAtStandbyID() {
        return socketAtStandbyID;
    }

    public void setSocketAtStandbyID(int socketAtStandbyID) {
        this.socketAtStandbyID = socketAtStandbyID;
    }




}
