package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * Object published by an Autochanger Online Clamp.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerOnlineClamp implements Serializable {
    private static final long serialVersionUID = -3995677445688405640L;

    private boolean lockSensorValue;
    private boolean unlockSensorValue;
    private LockStatus lockStatus;
    private boolean lockSensorInError;
    private boolean unlockSensorInError;
    private boolean inError;
    private boolean controllerInFault;
    private boolean controllerBooted;
    private int sentCurrent;
    private int current;
    private int position;
    private boolean homingDone;


    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(boolean lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public boolean getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(boolean unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }

    public boolean isLockSensorInError() {
        return lockSensorInError;
    }

    public void setLockSensorInError(boolean lockSensorInError) {
        this.lockSensorInError = lockSensorInError;
    }

    public boolean isUnlockSensorInError() {
        return unlockSensorInError;
    }

    public void setUnlockSensorInError(boolean unlockSensorInError) {
        this.unlockSensorInError = unlockSensorInError;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public boolean isControllerBooted() {
        return controllerBooted;
    }

    public void setControllerBooted(boolean controllerBooted) {
        this.controllerBooted = controllerBooted;
    }

    public boolean isControllerInFault() {
        return controllerInFault;
    }

    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public int getSentCurrent() {
        return sentCurrent;
    }

    public void setSentCurrent(int sentCurrent) {
        this.sentCurrent = sentCurrent;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

}
