
package org.lsst.ccs.subsystems.fcs;

/**
 * 
 * Data to be published on the STATUS bus by a CANopen device
 *
 * @author virieux
 */
public class StatusDataPublishedByCanOpenDevice extends StatusDataPublishedByHardware {
    private static final long serialVersionUID = -4729018504834624288L;
    
    private boolean inError;
    private String errorRegister;
    private int[] errorHistory;
    private String lastError;

    public StatusDataPublishedByCanOpenDevice(boolean isBooted, boolean isInitialized) {
        super(isBooted, isInitialized);
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public String getErrorRegister() {
        return errorRegister;
    }

    public void setErrorRegister(String errorRegister) {
        this.errorRegister = errorRegister;
    }

    public int[] getErrorHistory() {
        return errorHistory.clone();
    }

    public void setErrorHistory(int[] errorHistory) {
        this.errorHistory = errorHistory.clone();
    }

    public String getLastError() {
        return lastError;
    }

    public void setLastError(String lastError) {
        this.lastError = lastError;
    }

    
    
    
}
