package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.SlaveModuleStatus;

/**
 * An object that a Carousel Socket publishes on the STATUS bus for trending ddata persister and GUIs.
 * @author virieux
 */
public class StatusDataPublishedByCarouselSocket implements Serializable {
    private static final long serialVersionUID = 353558691508364042L;
    
    private SlaveModuleStatus slaveStatus;
    private boolean atStandby;
    private FilterClampState clampsState;
    private boolean empty;
    private int socketID;
    private String filterName;
    private int filterID;

    public SlaveModuleStatus getSlaveStatus() {
        return slaveStatus;
    }

    public void setSlaveStatus(SlaveModuleStatus slaveStatus) {
        this.slaveStatus = slaveStatus;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public FcsEnumerations.FilterClampState getClampState() {
        return clampsState;
    }

    public void setClampsState(FcsEnumerations.FilterClampState clampState) {
        this.clampsState = clampState;
    }

    
    public boolean isEmpty() {
        return empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public String getFilterName() {
        return filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public int getFilterID() {
        return filterID;
    }

    public void setFilterID(int filterID) {
        this.filterID = filterID;
    }
    
   

    public int getSocketID() {
        return socketID;
    }

    public void setSocketID(int socketID) {
        this.socketID = socketID;
    }


    
    
    
    
}
