package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.utilities.logging.Logger;

/**
 * Constants shared by main and GUIs.
 */
public final class FCSCst {
    
    /**
     * A Logger for all the subsystem FCS.
    */
    public static final Logger FCSLOG = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    /** Name of the tcpProxy for the autochanger and the carousel*/
    public static final String CHANGER_TCPPROXY_NAME = "tcpProxy";
    
    /** Name of the tcpProxy for the loader*/
    public static final String LOADER_TCPPROXY_NAME = "loaderTcpProxy";
    
    public static final String SOCKET_NAME= "socket";

    /* Names for autochanger*/
    public static final String AC_CLAMPSNAME= "onlineClamps";    
    public static final String AC_CLAMPXMINUS_NAME = "onlineClampXminus";
    public static final String AC_CLAMPXPLUS_NAME = "onlineClampXplus";
    public static final String AC_CLAMPYMINUS_NAME = "onlineClampYminus"; 
    public static final String AC_LATCHES_NAME = "latches";
    public static final String AC_LATCHXMINUS_NAME = "latchXminus";
    public static final String AC_LATCHXPLUS_NAME = "latchXplus";
    public static final String AC_TRUCKXMINUS_NAME = "acTruckXminus";
    public static final String AC_TRUCKXPLUS_NAME = "acTruckXplus";
    public static final String AC_TRUCKS_NAME= "autochangerTrucks";
    public static final String AC_PLUTO_GATEWAY_NAME= "acSensorsGateway";
    
    
    /*Represents the minimum value which can be returned by an analogic sensor.*/
    public static final int SENSOR14BITS_MIN = 0;
    
    /*Represents the maximum value which can be returned by an analogic sensor.*/
    public static final int SENSOR14BITS_MAX = 32767;
    
    /** String literals*/
    public static final String NOT_AT_STANDBY = "NOT AT STANDBY position";
    public static final String AT_STANDBY = "AT STANDBY position";   
    public static final String NO_FILTER = "NO FILTER";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String NO_ERROR = "NO ERROR";

    /*Private constructor to hide the implicit public constructor added by Java.*/
    private FCSCst() {
    }  
}
