package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 * An object to publish state of loader sensors :
 * - which detect filter presence on loader
 * - which detect if loader is connected on camera
 * @author virieux
 */
public class StatusDataPublishedByLoader implements Serializable {
    private static final long serialVersionUID = -6570268980297936654L;

    private boolean filterPresenceSensorValue;
    private boolean loaderOnCameraSensorValue;

    private boolean filterPresenceSensorsInError;
    private boolean loaderOnCameraSensorsInError;
    
    /** Camera protection system signals*/
    private boolean ap2;
    private boolean af0;
    private boolean af1;
    private boolean af3;
    
    private boolean ap2InError;
    private boolean af0InError;
    private boolean af1InError;
    private boolean af3InError;
    
    private boolean keyLock; //or permit
    private boolean keyEng;
    
    private boolean keyLockInError; //or permit
    private boolean keyEngInError;    
    /** end of Camera protection system signals*/
    
    public StatusDataPublishedByLoader() {
    }


    public boolean getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public boolean isFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(boolean filterPresenceSensorValue) {
        this.filterPresenceSensorValue = filterPresenceSensorValue;
    }

    public boolean isLoaderOnCameraSensorValue() {
        return loaderOnCameraSensorValue;
    }

    public void setLoaderOnCameraSensorValue(boolean loaderOnCameraSensorValue) {
        this.loaderOnCameraSensorValue = loaderOnCameraSensorValue;
    }

    public boolean isFilterPresenceSensorsInError() {
        return filterPresenceSensorsInError;
    }

    public void setFilterPresenceSensorsInError(boolean filterPresenceSensorsInError) {
        this.filterPresenceSensorsInError = filterPresenceSensorsInError;
    }

    public boolean isLoaderOnCameraSensorsInError() {
        return loaderOnCameraSensorsInError;
    }

    public void setLoaderOnCameraSensorsInError(boolean loaderOnCameraSensorsInError) {
        this.loaderOnCameraSensorsInError = loaderOnCameraSensorsInError;
    }

    public boolean isAp2() {
        return ap2;
    }

    public void setAp2(boolean ap2) {
        this.ap2 = ap2;
    }

    public boolean isAf0() {
        return af0;
    }

    public void setAf0(boolean af0) {
        this.af0 = af0;
    }

    public boolean isAf1() {
        return af1;
    }

    public void setAf1(boolean af1) {
        this.af1 = af1;
    }

    public boolean isAf3() {
        return af3;
    }

    public void setAf3(boolean af3) {
        this.af3 = af3;
    }

    public boolean isAp2InError() {
        return ap2InError;
    }

    public void setAp2InError(boolean ap2InError) {
        this.ap2InError = ap2InError;
    }

    public boolean isAf0InError() {
        return af0InError;
    }

    public void setAf0InError(boolean af0InError) {
        this.af0InError = af0InError;
    }

    public boolean isAf1InError() {
        return af1InError;
    }

    public void setAf1InError(boolean af1InError) {
        this.af1InError = af1InError;
    }

    public boolean isAf3InError() {
        return af3InError;
    }

    public void setAf3InError(boolean af3InError) {
        this.af3InError = af3InError;
    }

    public boolean isKeyLock() {
        return keyLock;
    }

    public void setKeyLock(boolean keyLock) {
        this.keyLock = keyLock;
    }

    public boolean isKeyEng() {
        return keyEng;
    }

    public void setKeyEng(boolean keyEng) {
        this.keyEng = keyEng;
    }

    public boolean isKeyLockInError() {
        return keyLockInError;
    }

    public void setKeyLockInError(boolean keyLockInError) {
        this.keyLockInError = keyLockInError;
    }

    public boolean isKeyEngInError() {
        return keyEngInError;
    }

    public void setKeyEngInError(boolean keyEngInError) {
        this.keyEngInError = keyEngInError;
    }

}
