
package org.lsst.ccs.subsystems.fcs;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderCarrier extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 3990208459528035053L;

    private int position;
    private int ssiPosition;
    private int speed;
    private int current;
    private boolean atStorage;
    private boolean atHandoff;
    private boolean atEngaged;
    private boolean handoffInError;
    private boolean engagedInError;
    private boolean storageInError;
    private boolean controllerInError;
    private boolean homingDone;

    private boolean limitSwitchDownInError;
    private boolean limitSwitchUpInError;

    public StatusDataPublishedByLoaderCarrier() {
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setHandoffInError(boolean handoffInError) {
        this.handoffInError = handoffInError;
    }

    public void setStorageInError(boolean storageInError) {
        this.storageInError = storageInError;
    }

    public void setEngagedInError(boolean engagedInError) {
        this.engagedInError = engagedInError;
    }

    public int getPosition() {
        return position;
    }

    public int getSsiPosition() {
        return ssiPosition;
    }

    public boolean isStorageInError() {
        return storageInError;
    }

    public boolean isHandoffInError() {
        return handoffInError;
    }

    public boolean isEngagedInError() {
        return engagedInError;
    }
    
    public int getSpeed() {
        return speed;
    }

    public int getCurrent() {
        return current;
    }

    public boolean isInError() {
        return controllerInError;
    }

    public boolean isAtStorage() {
        return atStorage;
    }

    public void setAtStorage(boolean storageSensorValue0) {
        this.atStorage = storageSensorValue0;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean handoffSensorValue0) {
        this.atHandoff = handoffSensorValue0;
    }


    public boolean isAtEngaged() {
        return atEngaged;
    }

    public void setAtEngaged(boolean engagedSensorValue0) {
        this.atEngaged = engagedSensorValue0;
    }

    public boolean isControllerInError() {
        return controllerInError;
    }

    public void setControllerInError(boolean controllerInError) {
        this.controllerInError = controllerInError;
    }

    public boolean isLimitSwitchDownInError() {
        return limitSwitchDownInError;
    }

    public void setLimitSwitchDownInError(boolean limitSwitchDownInError) {
        this.limitSwitchDownInError = limitSwitchDownInError;
    }

    public boolean isLimitSwitchUpInError() {
        return limitSwitchUpInError;
    }

    public void setLimitSwitchUpInError(boolean limitSwitchUpInError) {
        this.limitSwitchUpInError = limitSwitchUpInError;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }
    
    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/position=");
        sb.append(position);
        sb.append("/ssiPosition=");
        sb.append(ssiPosition);
        sb.append("/speed=");
        sb.append(speed);
        sb.append("/current=");
        sb.append(current);
        sb.append("/storageSensorValue=");
        sb.append(atStorage);
        sb.append("/storageSensorValue=");
        sb.append(atStorage);
        sb.append("/handoffInError=");
        sb.append(handoffInError);
        sb.append("/storageInError=");
        sb.append(storageInError);
        sb.append("/controllerInError=");
        sb.append(controllerInError);
        //sb.append("/errorMessage=");sb.append(controllerErrorMessage);
        return sb.toString();
    }

}
