
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * The data published on the Status Bus by a latch. A latch is what holds a
 * filter on an autochanger truck.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerLatch extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 2306413555514158111L;

    private boolean lockSensorValue = false;
    private boolean unlockSensorValue = false;
    private boolean filterPresenceSensorValue = false;
    private LockStatus lockStatus;
    private boolean inError;
    private boolean controllerInFault;
    private boolean lockSensorsInError;
    private boolean unlockSensorsInError;
    private boolean filterEngagedSensorsInError;

    //TODO update controllerInFault
    public StatusDataPublishedByAutochangerLatch() {
        name = "unknown latch";
        lockStatus = LockStatus.UNKNOWN;
        controllerInFault = false;
    }

    public boolean getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(boolean filterPositionSensorValue) {
        this.filterPresenceSensorValue = filterPositionSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(boolean lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public boolean getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(boolean unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public boolean isControllerInFault() {
        return controllerInFault;
    }

    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public boolean isLockSensorsInError() {
        return lockSensorsInError;
    }

    public void setLockSensorsInError(boolean lockSensorsInError) {
        this.lockSensorsInError = lockSensorsInError;
    }

    public boolean isUnlockSensorsInError() {
        return unlockSensorsInError;
    }

    public void setUnlockSensorsInError(boolean unlockSensorsInError) {
        this.unlockSensorsInError = unlockSensorsInError;
    }

    public boolean isFilterEngagedSensorsInError() {
        return filterEngagedSensorsInError;
    }

    public void setFilterEngagedSensorsInError(boolean filterEngagedSensorsValue) {
        this.filterEngagedSensorsInError = filterEngagedSensorsValue;
    }
    
    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" / state= ").append(lockStatus.toString());
        sb.append(" / filterPositionSensorValue= ").append(filterPresenceSensorValue);
        sb.append(" / unlockSensorValue= ").append(this.unlockSensorValue);
        sb.append(" / lockSensorValue= ").append(this.lockSensorValue);
        sb.append(" / controllerInFault= ").append(this.controllerInFault);
        return sb.toString();
    }

}
