
package org.lsst.ccs.subsystems.fcs;

/**
 * To publish on the status bus the AutoChangerTrucksModule data.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutoChangerTrucks extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 8770787257648489652L;
    
    private int masterPosition = 0;
    private int slavePosition = 0;
    private int speed = 0;
    private int current = 0;
    private boolean masterControllerInFault = false;
    private boolean slaveControllerInFault = false;
    private boolean homingDone = false;
    /**
     * true if Handoff masterPosition sensors for TruckXminus and TruckXplus return value 1*
     */
    private boolean atHandoff = false;

    /**
     * true if Online masterPosition sensors for TruckXminus and TruckXplus return value 1 *
     */
    private boolean atOnline = false;

    /**
     * true if Standby masterPosition sensors for TruckXminus and TruckXplus return value 1 *
     */
    private boolean atStandby = false;  
    
    /**
     * true if masterPosition sensors are in error. *
     */
    private boolean inError = false;    
    
    


    public int getMasterPosition() {
        return masterPosition;
    }

    public void setMasterPosition(int position) {
        this.masterPosition = position;
    }

    public int getSlavePosition() {
        return slavePosition;
    }

    public void setSlavePosition(int slavePosition) {
        this.slavePosition = slavePosition;
    }

    public boolean isMasterControllerInFault() {
        return masterControllerInFault;
    }

    public void setMasterControllerInFault(boolean masterControllerInFault) {
        this.masterControllerInFault = masterControllerInFault;
    }

    public boolean isSlaveControllerInFault() {
        return slaveControllerInFault;
    }

    public void setSlaveControllerInFault(boolean slaveControllerInFault) {
        this.slaveControllerInFault = slaveControllerInFault;
    }

    public boolean isLimitSwitchUpInError() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public boolean isLimitSwitchDownInError() {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    public int getSpeed() {
        return speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }

    public boolean isAtHandoff() {
        return atHandoff;
    }

    public void setAtHandoff(boolean atHandoff) {
        this.atHandoff = atHandoff;
    }

    public boolean isAtOnline() {
        return atOnline;
    }

    public void setAtOnline(boolean atOnline) {
        this.atOnline = atOnline;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("/position=");
        sb.append(masterPosition);
        sb.append("/speed=");
        sb.append(speed);
        sb.append("/current=");
        sb.append(current);
        sb.append("/masterControllerInFault=");
        sb.append(masterControllerInFault);
        sb.append("/slaveControllerInFault=");
        sb.append(slaveControllerInFault);
        return sb.toString();
    }

}
