package org.lsst.ccs.subsystems.fcs;

/**
 *
 * A structure for the data published on the status bus by the
 * AutoChangerModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByAutoChanger extends StatusDataPublishedByFCS {

    private static final long serialVersionUID = 1L;
    private boolean loaderConnectedSensorValue;
    private boolean loaderConnectedSensorsInError;
    private double inclinaisonXminus;
    private double inclinaisonXplus;

    public boolean getLoaderConnectedSensorValue() {
        return loaderConnectedSensorValue;
    }

    public void setLoaderConnectedSensorValue(boolean loaderConnectedSensorValue0) {
        this.loaderConnectedSensorValue = loaderConnectedSensorValue0;
    }

    public boolean isLoaderConnectedSensorsInError() {
        return loaderConnectedSensorsInError;
    }

    public void setLoaderConnectedSensorsInError(boolean loaderConnectedSensorsInError) {
        this.loaderConnectedSensorsInError = loaderConnectedSensorsInError;
    }

    public double getInclinaisonXminus() {
        return inclinaisonXminus;
    }

    public void setInclinaisonXminus(double inclinaisonXminus) {
        this.inclinaisonXminus = inclinaisonXminus;
    }

    public double getInclinaisonXplus() {
        return inclinaisonXplus;
    }

    public void setInclinaisonXplus(double inclinaisonXplus) {
        this.inclinaisonXplus = inclinaisonXplus;
    }
    
    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("loader connected=").append(loaderConnectedSensorValue);
        sb.append("loaderConnected sensor in error=").append(loaderConnectedSensorsInError);
        return sb.toString();
    }

}
