
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * Throwned when we received an emergency message for a node.
 *
 * @author virieux
 */
public class CanOpenException extends FcsHardwareException {
    private static final long serialVersionUID = 6089864952853658723L;

    /**
     * Node ID of the node in error in hexa.
     */
    private String nodeID;

    /**
     * Device error code in hexadecimal format.
     */
    private String errCode;

    /**
     * Creates a new instance of <code>CanOpenError</code> without detail
     * message.
     */
    public CanOpenException() {
        super("Error on a CANopen device.");
    }

    /**
     * Constructs an instance of <code>CanOpenError</code> with the specified
     * detail message.
     *
     * @param msg the detail message.
     */
    public CanOpenException(String msg) {
        super(msg);
    }

    public CanOpenException(String msg, String nodeID, String errCode) {
        super(msg);
        this.nodeID = nodeID;
        this.errCode = errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;

    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.nodeID != null) sb.append(" NODE ID=").append(this.nodeID);
        if (this.errCode != null) sb.append(" CANopen device error code=").append(this.errCode);
        return sb.toString();
    }
}
