
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByLoaderHook extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 8530682890292854677L;

    private final boolean lockSensorValue;
    private final boolean unlockSensorValue;
    private final boolean inError;
    private final LockStatus lockStatus;

    public StatusDataPublishedByLoaderHook(String name,
            boolean lockSensorValue,
            boolean unlockSensorValue,
            boolean inError,
            LockStatus lockStatus) {
        this.name = name;
        this.lockSensorValue = lockSensorValue;
        this.unlockSensorValue = unlockSensorValue;
        this.inError = inError;
        this.lockStatus = lockStatus;
    }

    public boolean getLockSensorValue() {
        return lockSensorValue;
    }

    public boolean getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public boolean isInError() {
        return inError;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }





}
