package org.lsst.ccs.subsystems.fcs;

/**
 * An object to publish state of loader sensors :
 * - which detect filter presence on loader
 * - which detect if loader is connected on camera
 * @author virieux
 */
public class StatusDataPublishedByLoader extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = -6570268980297936654L;

    private boolean filterPresenceSensorValue;
    private boolean loaderOnCameraSensorValue;

    private boolean filterPresenceSensorsInError;
    private boolean loaderOnCameraSensorsInError;

    public StatusDataPublishedByLoader() {
    }


    public boolean getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public boolean isFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(boolean filterPresenceSensorValue) {
        this.filterPresenceSensorValue = filterPresenceSensorValue;
    }

    public boolean isLoaderOnCameraSensorValue() {
        return loaderOnCameraSensorValue;
    }

    public void setLoaderOnCameraSensorValue(boolean loaderOnCameraSensorValue) {
        this.loaderOnCameraSensorValue = loaderOnCameraSensorValue;
    }

    public boolean isFilterPresenceSensorsInError() {
        return filterPresenceSensorsInError;
    }

    public void setFilterPresenceSensorsInError(boolean filterPresenceSensorsInError) {
        this.filterPresenceSensorsInError = filterPresenceSensorsInError;
    }

    public boolean isLoaderOnCameraSensorsInError() {
        return loaderOnCameraSensorsInError;
    }

    public void setLoaderOnCameraSensorsInError(boolean loaderOnCameraSensorsInError) {
        this.loaderOnCameraSensorsInError = loaderOnCameraSensorsInError;
    }

}
