
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 *
 * A structure for the data published on the status bus by the ClampModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarouselClamp extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 3238914072953604160L;

    private String clampState;
    private FilterPresenceStatus filterPresenceStatus;
    private int filterPositionSensorValue;
    private LockStatus lockStatus;
    private int lockSensorValue;
    private double temperature;

    public StatusDataPublishedByCarouselClamp() {
        name = "unknown clamp";
        clampState = "unknown";
        filterPresenceStatus = FilterPresenceStatus.UNKNOWN;
        filterPositionSensorValue = 0;
        lockStatus = LockStatus.UNKNOWN;
        lockSensorValue = 0;
        temperature = 0;
    }

    public void setFilterPresenceStatus(FilterPresenceStatus filterPositionInClamp) {
        this.filterPresenceStatus = filterPositionInClamp;
    }

    public void setFilterPositionSensorValue(int filterPositionSensorValue) {
        this.filterPositionSensorValue = filterPositionSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return temperature;
    }

    public FilterPresenceStatus getFilterPresenceStatus() {
        return filterPresenceStatus;
    }

    public int getFilterPositionSensorValue() {
        return filterPositionSensorValue;
    }

    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public String getClampState() {
        return clampState;
    }

    public void setClampState(String clampState) {
        this.clampState = clampState;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" / state= ").append(clampState);
        sb.append(" / filterPositionInClamp= ").append(filterPresenceStatus);
        sb.append(" / filterPositionSensorValue= ").append(filterPositionSensorValue);
        sb.append(" / lockStatus= ").append(lockStatus);
        sb.append(" / lockSensorValue= ").append(lockSensorValue);
        return sb.toString();
    }

}
