package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import java.util.TreeMap;

/**
 *
 * A structure for the data published on the status bus by the CarouselModule.
 *
 * @author virieux
 *
 */
public class StatusDataPublishedByCarousel extends StatusDataPublishedByFCS {

    private static final long serialVersionUID = 7037058370873652888L;
    private double position;
    private boolean locked;
    private boolean homingDone;
    private boolean atStandby;
    private double speed;
    private double current;
    private String filterAtStandbyName;
    private String socketAtStandbyName;
    private String filterOnAutochangerName;
    
    /*A Map which represents the filters on camera.*/
    /*key = socketName; value = filterName*/
    private Map<String,String> filtersOnCamera;

    /**
     * To create a new StatusDataPublishedByCarousel with default values.
     */
    public StatusDataPublishedByCarousel() {
        position = 0.0;
        locked = false;
        homingDone = false;
        filterAtStandbyName = "none";
        filtersOnCamera = new TreeMap<>();
    }

    public boolean isLocked() {
        return locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public double getPosition() {
        return position;
    }

    public String getFilterAtStandbyName() {
        return filterAtStandbyName;
    }


    public void setFilterAtStandbyName(String filterInStandbyName) {
        this.filterAtStandbyName = filterInStandbyName;
    }

    public boolean isHomingDone() {
        return homingDone;
    }

    public void setHomingDone(boolean homingDone) {
        this.homingDone = homingDone;
    }   

    public String getFilterOnAutochangerName() {
        return filterOnAutochangerName;
    }

    public void setFilterOnAutochangerName(String filterOnAutochangerName) {
        this.filterOnAutochangerName = filterOnAutochangerName;
    }

    public String getSocketAtStandbyName() {
        return socketAtStandbyName;
    }

    public void setSocketAtStandbyName(String socketAtStandbyName) {
        this.socketAtStandbyName = socketAtStandbyName;
    }
    

    public void setPosition(double position) {
        this.position = position;
    }

    public boolean isAtStandby() {
        return atStandby;
    }

    public void setAtStandby(boolean atStandby) {
        this.atStandby = atStandby;
    }   

    public double getSpeed() {
        return speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public double getCurrent() {
        return current;
    }

    public void setCurrent(double current) {
        this.current = current;
    }

    public Map<String, String> getFiltersOnCamera() {
        return filtersOnCamera;
    }

    public void setFiltersOnCamera(Map<String, String> filtersOnCamera) {
        this.filtersOnCamera = filtersOnCamera;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/Carousel POSITION = ");
        sb.append(this.position);
        sb.append("; carousel is locked=");
        sb.append(this.locked);
        sb.append("; carousel is AT STANDBY=");
        sb.append(this.atStandby);
        sb.append("/ Filter in Standby position= ");
        sb.append(this.filterAtStandbyName).append(" /");
        return sb.toString();
    }    
    
    
}
