
package org.lsst.ccs.subsystems.fcs;

import java.util.Arrays;

/**
 * 
 * Data to be published on the STATUS bus by a CANopen device
 *
 * @author virieux
 */
public class StatusDataPublishedByCanOpenDevice extends StatusDataPublishedByHardware {
    private static final long serialVersionUID = -4729018504834624288L;
    
    private boolean inError;
    private String errorRegister;
    private int[] errorHistory;

    public StatusDataPublishedByCanOpenDevice(String name, boolean isBooted, boolean isInitialized) {
        super(name, isBooted, isInitialized);
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public String getErrorRegister() {
        return errorRegister;
    }

    public void setErrorRegister(String errorRegister) {
        this.errorRegister = errorRegister;
    }

    public int[] getErrorHistory() {
        return errorHistory.clone();
    }

    public void setErrorHistory(int[] errorHistory) {
        this.errorHistory = errorHistory.clone();
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/inError=");
        sb.append(inError);
        sb.append("/Error Register=");
        sb.append(errorRegister);
        sb.append("/Error History=");
        sb.append(Arrays.toString(errorHistory));
        return sb.toString();
    }
    
    
}
