/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is throwned when a SDO command returns an error code.
 * //TODO is this Exception useful ?
 * //It has to have  a constructor with a throwable.
 * @author virieux
 */
public class SDORequestException extends CanOpenException {
    private static final long serialVersionUID = -1589446966356817385L;

    private String index;
    private String subindex;
    private String errorName;

    /**
     * Creates a new instance of <code>SDORequestError</code> without detail
     * message.
     */
    public SDORequestException() {
    }

    /**
     * Constructs an instance of <code>SDORequestError</code> with the specified
     * detail message.
     *
     * @param msg the detail message.
     */
    public SDORequestException(String msg) {
        super(msg);
    }

    public SDORequestException(String msg, String nodeID, String errorCode, 
            String index, String subindex, String errorName) {
        super(msg, nodeID, errorCode);
        this.index = index;
        this.subindex = subindex;
        this.errorName = errorName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (index != null) sb.append(" index=").append(index);
        if (subindex != null) sb.append(" subindex=").append(subindex);
        if (errorName != null) sb.append(" error name=").append(errorName);
        return sb.toString();
    }
    
    /**
     * Just for tests
     * @param argv 
     */
    public static void main(String[] argv) {
        SDORequestException ex= new SDORequestException("COUCOU", "1a", "80", 
                "1010", "02", "Temperature");
        System.out.println(ex.toString());
        SDORequestException ex2= new SDORequestException("TOTO");
        System.out.println(ex2.toString());
    }
}
