/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * A generic hardware error.
 *
 * @author virieux
 */
public class FcsHardwareException extends RuntimeException {
    private static final long serialVersionUID = -1611565916911805775L;

    /**
     * Name of the hardware
     */
    protected String hardwareName;

    public FcsHardwareException() {
        super("An hardware error has been detected.");
    }

    public FcsHardwareException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs an instance of <code>HardwareError</code> with the specified
     * detail message.
     *
     * @param msg the detail message.
     */
    public FcsHardwareException(String msg) {
        super(msg);
    }

    /**
     * Constructs an instance of <code>HardwareError</code> with the specified
     * detail message and the name of the hardware in error.
     *
     * @param msg
     * @param name
     */
    public FcsHardwareException(String msg, String name) {
        super(msg);
        this.hardwareName = name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (!(this.hardwareName == null)) {
            sb.append(" /Hardware in error: ").append(hardwareName);
        }
        return sb.toString();
    }

}
