/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 * An object to be published on the Status bus by a Piece of Hardware.
 * @author virieux
 */
public class StatusDataPublishedByHardware extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 3854847105567797037L;

    private boolean booted;
    private boolean initialized;

    public StatusDataPublishedByHardware() {
    }

    public StatusDataPublishedByHardware(String name, boolean isBooted,
            boolean isInitialized) {
        this.name = name;
        this.booted = isBooted;
        this.initialized = isInitialized;
    }

    public boolean isBooted() {
        return booted;
    }

    public void setBooted(boolean booted) {
        this.booted = booted;
    }

    public boolean isInitialized() {
        return initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(name);
        sb.append("/isBooted=");
        sb.append(booted);
        sb.append("/isInitialized=");
        sb.append(initialized);
        return sb.toString();
    }

}
