/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;

/**
 * The data published on the Status Bus by a latch. A latch is what holds a
 * filter on an autochanger truck.
 *
 * @author virieux
 */
public class StatusDataPublishedByAutochangerLatch extends StatusDataPublishedByFCS {
    private static final long serialVersionUID = 2306413555514158111L;

    private int lockSensorValue;
    private int unlockSensorValue;
    private int filterPresenceSensorValue;
    private LockStatus lockStatus;
    private boolean inError;
    private boolean controllerInFault;
    private boolean lockSensorsInError;
    private boolean unlockSensorsInError;
    private boolean filterEngagedSensorsInError;

    //TODO update controllerInFault
    public StatusDataPublishedByAutochangerLatch() {
        name = "unknown latch";
        lockSensorValue = 0;
        unlockSensorValue = 1;
        filterPresenceSensorValue = 0;
        lockStatus = LockStatus.UNKNOWN;
        controllerInFault = false;
    }

    public int getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(int filterPositionSensorValue) {
        this.filterPresenceSensorValue = filterPositionSensorValue;
    }

    public LockStatus getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public int getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(int unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }

    public boolean isControllerInFault() {
        return controllerInFault;
    }

    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }

    public boolean isLockSensorsInError() {
        return lockSensorsInError;
    }

    public void setLockSensorsInError(boolean lockSensorsInError) {
        this.lockSensorsInError = lockSensorsInError;
    }

    public boolean isUnlockSensorsInError() {
        return unlockSensorsInError;
    }

    public void setUnlockSensorsInError(boolean unlockSensorsInError) {
        this.unlockSensorsInError = unlockSensorsInError;
    }

    public boolean isFilterEngagedSensorsInError() {
        return filterEngagedSensorsInError;
    }

    public void setFilterEngagedSensorsInError(boolean filterEngagedSensorsValue) {
        this.filterEngagedSensorsInError = filterEngagedSensorsValue;
    }
    
    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" / state= ").append(lockStatus.toString());
        sb.append(" / filterPositionSensorValue= ").append(filterPresenceSensorValue);
        sb.append(" / unlockSensorValue= ").append(this.unlockSensorValue);
        sb.append(" / lockSensorValue= ").append(this.lockSensorValue);
        sb.append(" / controllerInFault= ").append(this.controllerInFault);
        return sb.toString();
    }

}
