/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is thrown when we get a bad response from a PDO request.
 *
 * @author virieux
 */
public class PDOBadResponseException extends CanOpenException {
    private static final long serialVersionUID = -5149852531929173439L;

    String response;

    public PDOBadResponseException(String message) {
        super(message);
    }

    public PDOBadResponseException(String message, String response) {
        super(message);
        this.response = response;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" response=");
        sb.append(response);
        return sb.toString();
    }

}
