/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * This exception is throwned when the hardware configuration of a motor is not
 * the same than the software configuration.
 *
 * @author virieux
 */
public class EPOSConfigurationException extends FcsHardwareException {

    int motorType;
    int continuousCurrentLimit; /*UNIT= mA* FORMAT=decimal*/

    int maxSpeedInCurrentMode; /*UNIT= rpm* FORMAT=decimal*/

    int thermalTimeConstantWinding; /*100 ms* FORMAT=decimal*/

    int outputCurrentLimit; /*100 mA* FORMAT=decimal*/

    int polePairNumber; /* no unit FORMAT=decimal*/


    /**
     * Creates a new instance of <code>ClampMotorConfigurationError</code>
     * without detail message.
     */
    public EPOSConfigurationException() {
    }

    /**
     * Constructs an instance of <code>ClampMotorConfigurationError</code> with
     * the specified detail message.
     *
     * @param msg the detail message.
     */
    public EPOSConfigurationException(String msg) {
        super(msg);
    }

    /**
     * Constructs an instance of <code>ClampMotorConfigurationError</code> with
     * the specified detail message and the name of the hardware.
     *
     * @param msg the detail message.
     * @param name the hardware name.
     */
    public EPOSConfigurationException(String msg, String name) {
        super(msg, name);
    }

    /**
     * Constructs an instance of <code>ClampMotorConfigurationError</code> with
     * the specified detail message and the value read of the motor parameters.
     *
     * @param msg the detail message.
     */
    public EPOSConfigurationException(String msg,
            String name,
            int motorType,
            int continuousCurrentLimit,
            int maxSpeedInCurrentMode,
            int thermalTimeConstantWinding,
            int outputCurrentLimit,
            int polePairNumber) {
        super(msg, name);
        this.motorType = motorType;
        this.continuousCurrentLimit = continuousCurrentLimit;
        this.maxSpeedInCurrentMode = maxSpeedInCurrentMode;
        this.thermalTimeConstantWinding = thermalTimeConstantWinding;
        this.outputCurrentLimit = outputCurrentLimit;
        this.polePairNumber = polePairNumber;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" Read values for motor parameter are =");
        sb.append(" motor type =");
        sb.append(this.motorType);
        sb.append(" continuousCurrentLimit =");
        sb.append(this.continuousCurrentLimit);
        sb.append(" maxSpeedInCurrentMode =");
        sb.append(this.maxSpeedInCurrentMode);
        sb.append(" thermalTimeConstantWinding =");
        sb.append(this.thermalTimeConstantWinding);
        sb.append(" outputCurrentLimit =");
        sb.append(this.outputCurrentLimit);
        sb.append(" polePairNumber =");
        sb.append(this.polePairNumber);

        return sb.toString();
    }

}
