/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 *
 * @author virieux
 */
public class CWrapperNotConnected extends Exception {
    private static final long serialVersionUID = 8294308378190923559L;

    int portNumber;
    String clientName;

    public CWrapperNotConnected(int portNumber, String clientName) {
        super("The CWrapper is not connected.");
        this.portNumber = portNumber;
        this.clientName = clientName;
    }

    public CWrapperNotConnected(int portNumber, String clientName, String message) {
        super(message);
        this.portNumber = portNumber;
        this.clientName = clientName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(this.getMessage());
        sb.append("/TCP server waiting on port=");
        sb.append(this.portNumber);
        sb.append("/client name should be=");
        sb.append(clientName);
        return sb.toString();
    }

}
