/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import java.awt.Color;

/**
 *
 * @author turri
 */
public class FcsEnumerations {

    public static final Color greenColor = new Color(0, 165, 0);
    public static final Color darkGreen = new Color(0, 100, 0);

    /* On which part of the FilterChanger the filter can be.*/
    public enum FilterLocation {

        CAROUSEL, AUTOCHANGER, LOADER, OUT, UNKNOWN
    }
    
    /**
     * An interface for an object to be displayed on the GUI with the appropriate color.
     */
    public interface ColoredObject {
        Color getColor();
    }

    /**
     * The different possibilities for a carousel clamp within the presence of a
     * filter : - no filter - filter engaged and lockable - unknown state -
     * sensor in error The different possibilities for a latch in the
     * autochanger within the presence of a filter : - no filter - filter
     * engaged - unknown state
     *
     */
    public enum FilterPresenceStatus implements ColoredObject {

        NOFILTER(Color.DARK_GRAY), 
        ENGAGED(greenColor), 
        LOCKABLE(greenColor), 
        NOT_LOCKABLE(Color.orange), 
        ERROR(Color.red), 
        UNKNOWN(Color.gray);
        
        private final Color color;

        private FilterPresenceStatus(Color color) {
            this.color = color;
        }
        

        @Override
        public Color getColor() {
            return this.color;
        }
    }

    /* For the autochanger in single-filter-test*/
    @Deprecated
    public enum FilterPresenceInLatchStatus {

        NOFILTER, ENGAGED, UNKNOWN, ERROR,
    }

    /* Used for the loader clamp and autochanger latches and online clamps*/
    public enum LockStatus implements ColoredObject {

        UNLOCKED(Color.blue, "UNLOCKED"),
        LOCKED(greenColor, "LOCKED"),
        UNKNOWN(Color.orange, "UNKNOWN"),
        ERROR(Color.red, "IN ERROR"),
        CLAMPED(darkGreen, "CLAMPED"), //used for the loader clamp

        INTRAVEL(Color.YELLOW, "IN TRAVEL"), //when neither locked, nor locked

        NOERROR(Color.GREEN, "NO ERROR"); // for the GUI's digital switch "NO ERROR"

        private final Color color;
        private final String text;

        private LockStatus(Color color, String text) {
            this.color = color;
            this.text = text;
        }

        public Color getColor() {
            return color;
        }

        public String getText() {
            return text;
        }

    }

    public enum AutoChangerTrucksLocation {

        STANDBY, STANDBACK, HANDOFF, ONLINE, UNKNOWN, ERROR,
    }

    public enum LoaderCarrierLocation {

        STORAGE, HANDOFF, UNKNOWN, ERROR
    }

    /*For the carousel clamp*/
    public enum FilterClampState implements ColoredObject {

        READYTOCLAMP(Color.blue, "READY TO CLAMP"),
        UNCLAMPEDONFILTER(Color.orange,"UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY(Color.DARK_GRAY,"UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER(greenColor,"CLAMPED ON FILTER"),
        UNDEFINED(Color.YELLOW,"UNDEFINED"),
        ERROR(Color.red,"IN ERROR");

        private final String shortDescription;
        private final Color color;

        FilterClampState(Color color, String aString) {
            this.shortDescription = aString;
            this.color = color;
        }

        @Override
        public String toString() {
            return shortDescription;
        }

        @Override
        public Color getColor() {
            return color;
        }
    }

    /*Used for the rotation of the carousel*/
    public enum RunningWay {

        POSITIVE, NEGATIVE
    }

    /**
     * This is the different actions that can be made by a MobileItemModule. For
     * each of these actions, there is 3 String fields to define, they are
     * messages that are displayed at the console in Engineering mode or in the
     * Tracer, and log BUS: 1-when doing the action 2-when the action is
     * completed with success, 3-when the action couldn't be completed.
     */
    public enum MobileItemAction {
        /*CAROUSEL ACTIONS*/

        //actions for the carousel clamps
        UNLOCK("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        UNLOCKCLAMPS("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASECLAMPS("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        /*END OF CAROUSEL ACTIONS*/
        /*AUTOCHANGER ACTIONS*/
        //actions for the autochanger latches
        OPEN("OPENING LATCH", "IS OPEN", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        OPENLATCHES("OPENING LATCHES AT STANDBY", "LATCHES ARE OPEN", "COULD NOT OPEN LATCHES"),
        CLOSELATCHES("CLOSING LATCHES AT STANDBY", "LATCHES ARE CLOSED", "COULD NOT CLOSE LATCHES"),
        UNLOCK_ONLINECLAMP("UNLOCKING ONLINECLAMP", "IS UNLOCKED", "COULD NOT UNLOCK ONLINECLAMP"),
        LOCK_ONLINECLAMP("LOCKING ONLINECLAMP", "IS LOCKED", "COULD NOT LOCK ONLINECLAMP"),
        UNLOCK_ONLINECLAMPS("UNLOCKING ONLINECLAMPS", "ARE UNLOCKED", "COULD NOT UNLOCK ONLINECLAMPS"),
        LOCK_ONLINECLAMPS("LOCKING ONLINECLAMPS", "ARE LOCKED", "COULD NOT LOCK ONLINECLAMPS"),
        MOVE_TO_ABSOLUTE_POSITION("MOVING TO ABSOLUTE POSITION", "ABSOLUTE POSITION REACHED",
                "COULD NOT MOVE TO ABSOLUTE POSITION"),
        MOVE_TO_RELATIVE_POSITION("MOVING TO RELATIVE POSITION", "RELATIVE POSITION REACHED",
                "COULD NOT MOVE TO RELATIVE POSITION"),
        /*END OF AUTOCHANGER ACTIONS*/
        /*LOADER ACTIONS*/
        //actions of the loader clamp
        GOTOCLAMPEDPOSITION("LOADER CLAMP GOING TO CLAMPED POSITION", "HOOKS ARE AT CLAMPED POSITION", "COULD NOT GO TO CLAMPED POSITION"),
        GOTOHOMEPOSITION("LOADER CLAMP GOING TO HOME POSITION", "HOOKS ARE AT HOME POSITION", "COULD NOT GO TO HOME POSITION"),
        OPENLOADERHOOKS("OPENING LOADER HOOKS", "LOADER HOOKS ARE OPEN", "COULD NOT OPEN LOADER HOOKS"),
        CLOSELOADERHOOKS("CLOSING LOADER HOOKS", "LOADER HOOKS ARE CLOSED", "COULD NOT CLOSE LOADER HOOKS"),
        CLAMPLOADERHOOKS("CLAMPING LOADER HOOKS", "LOADER HOOKS ARE CLAMPED", "COULD NOT CLAMP LOADER HOOKS"),
        //actions of the loader carrier
        MOVELOADERCARRIERTOSTORAGE("MOVING LOADER CARRIER TO STORAGE", "LOADER CARRIER IS AT STORAGE POSITION", "COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVELOADERCARRIERTOHANDOFF("MOVING LOADER CARRIER TO HANDOFF", "LOADER CARRIER IS AT HANDOFF POSITION", "COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION");
        /*END OF LOADER ACTIONS*//*END OF LOADER ACTIONS*/

        private final String shortDescription;
        private final String doneActionMsg;
        private final String failureMsg;

        MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.shortDescription = aString;
            this.doneActionMsg = aDoneString;
            this.failureMsg = aFailureMsg;
        }

        @Override
        public String toString() {
            return shortDescription;
        }

        public String doneString() {
            return doneActionMsg;
        }

        public String getFailureMsg() {
            return failureMsg;
        }
    }

}
