package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.utilities.logging.Logger;

/**
 * Constants shared by main and GUIs.
 */
public class FCSCst {
    
    /**
     * A Logger for all the subsystem FCS.
    */
    public static final Logger FCSLOG = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    /** Name of the tcpProxy for the autochanger and the carousel*/
    public static final String CHANGER_TCPPROXY_NAME = "tcpProxy";
    
    /** Name of the tcpProxy for the loader*/
    public static final String LOADER_TCPPROXY_NAME = "loaderTcpProxy";
    
    /*Represents the minimum value which can be returned by an analogic sensor.*/
    public static final int SENSOR14BITS_MIN = 0;
    
    /*Represents the maximum value which can be returned by an analogic sensor.*/
    public static final int SENSOR14BITS_MAX = 32767;
    
    /** String literals*/
    public static final String NOT_AT_STANDBY = "NOT AT STANDBY position";
    public static final String AT_STANDBY = "AT STANDBY position";   
    public static final String NO_FILTER = "NO FILTER";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String NO_ERROR = "NO ERROR";

    /*Private constructor to hide the implicit public constructor added by Java.*/
    private FCSCst() {
    }  
}
