/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 * Here are 2 Enum : Parameter and EposMode
 *
 * @author virieux
 */
public class EPOSEnumerations {

    /**
     * Here are the parameters that we can set in an Epos controller. cf EPOS
     * Application Notes Collection
     */
    public enum Parameter {

        ConfigurationOfDigitalInput1("2070", "01", "2", false),
        ConfigurationOfDigitalInput2("2070", "02", "2", false),
        ConfigurationOfDigitalInput3("2070", "03", "2", false),
        DigitalInputFonctionnalityState("2071", "01", "2", false),
        DigitalInputFonctionnalityMask("2071", "02", "2", false),
        DigitalInputFonctionnalityPolarity("2071", "03", "2", false),
        DigitalInputFonctionnalityExecutionMask("2071", "04", "2", false),
        DigitalOutputFonctionnalityState("2078", "01", "2", false),
        DigitalOutputFonctionnalityMask("2078", "02", "2", false),
        DigitalOutputFonctionnalityPolarity("2078", "03", "2", false),
        ConfigurationOfDigitalOutput1("2079", "01", "2", false),
        ConfigurationOfDigitalOutput2("2079", "02", "2", false),
        ConfigurationOfDigitalOutput3("2079", "03", "2", false),
        ConfigurationOfDigitalOutput4("2079", "04", "2", false),
        CurrentThresholdHomingMode("2080", "00", "1", false),
        HomePosition("2081", "00", "4", false),
        BrakeReactionRiseTime("2100", "01", "2", false),
        BrakeReactionFallTime("2100", "02", "2", false),
        BrakeTimeout("2100", "03", "2", false),
        PositionSensorType("2210", "02", "2", false),
        SSIEncoderActualPosition("2211", "03", "4", true), //SingleSerialData encodeur absolu only for EPOS70/10
        PositionActualValue("6064", "00", "4", true),
        MaxFollowingError("6065", "00", "4", false),
        HomeOffset("607C", "00", "4", true),
        MinPositionLimit("607D", "01", "4", true),
        MaxPositionLimit("607D", "02", "4", true),
        MaxProfileVelocity("607F", "00", "4", false),
        ProfileVelocity("6081", "00", "4", false),
        ProfileAcceleration("6083", "00", "4", false),
        ProfileDeceleration("6084", "00", "4", false),
        QuickStopDeceleration("6085", "00", "4", false),
        MotionProfileType("6086", "00", "2", false),
        HomingMethod("6098", "00", "1", true),
        SpeedForSwitchSearch("6099", "01", "2", false),
        SpeedForZeroSearch("6099", "02", "2", false),
        HomingAcceleration("609A", "00", "2", false),
        MotorType("6402", "00", "2", false),
        ContinuousCurrentLimit("6410", "01", "2", false),
        OutputCurrentLimit("6410", "02", "2", false),
        PolePairNumber("6410", "03", "1", false),
        MaxSpeedInCurrentMode("6410", "04", "4", false),
        ThermalTimeConstantWinding("6410", "05", "2", false),
        StatusWord("6041", "00", "2", false),;

        private final String index;
        private final String subindex;
        /* Size of the parameter : numbers of bytes*/
        private final String size;
        /*false if UNSIGNED else true*/
        private final boolean signed;

        private Parameter(String index, String subindex, String size, boolean signed) {
            this.index = index;
            this.subindex = subindex;
            this.size = size;
            this.signed = signed;

        }

        public String getIndex() {
            return index;
        }

        public String getSubindex() {
            return subindex;
        }

        public String getSize() {
            return size;
        }

        public boolean isSigned() {
            return signed;
        }

        public String display() {
            StringBuilder sb = new StringBuilder(this.toString());
            sb.append("/index=").append(this.index);
            sb.append("/subindex=").append(this.subindex);
            sb.append("/size=").append(this.size).append(" bytes");
            if (signed) {
                sb.append("/SIGNED");
            } else {
                sb.append("/UNSIGNED");
            }
            return sb.toString();
        }

    }

    /**
     * Here are all the modes that can be configurated for an EPOS controller.
     * For each mode, some parameters have to be set : field parameters
     */
    public enum EposMode {

        HOMING("6", Parameter.MaxFollowingError, Parameter.HomeOffset, Parameter.MaxProfileVelocity,
                Parameter.QuickStopDeceleration, Parameter.SpeedForSwitchSearch,
                Parameter.SpeedForZeroSearch, Parameter.HomingAcceleration,
                Parameter.CurrentThresholdHomingMode, Parameter.HomePosition),
        PROFILE_POSITION("1", Parameter.MaxFollowingError, Parameter.MinPositionLimit,
                Parameter.MaxPositionLimit, Parameter.MaxProfileVelocity,
                Parameter.ProfileVelocity, Parameter.ProfileAcceleration,
                Parameter.ProfileDeceleration, Parameter.QuickStopDeceleration,
                Parameter.MotionProfileType),
        PROFILE_VELOCITY("3"),
        POSITION("FF"),
        MASTER_ENCODER("FB"),
        VELOCITY("FE"),
        CURRENT("FD", Parameter.ContinuousCurrentLimit,
                Parameter.OutputCurrentLimit, Parameter.MaxSpeedInCurrentMode,
                //the following parameters are specific to the motor that we control with this controller.
                Parameter.PolePairNumber, Parameter.ThermalTimeConstantWinding,
                Parameter.MotorType, Parameter.PositionSensorType);

        private final String modeInHexa;
        private final Parameter[] parameters;

        private EposMode(String modeToHexa, Parameter... params) {
            this.modeInHexa = modeToHexa;
            this.parameters = params.clone();
        }

        public String getModeInHexa() {
            return this.modeInHexa;
        }

        public Parameter[] getParameters() {
            return parameters.clone();
        }

        /**
         * Retrieve and returns a mode which hexa code is given as an argument.
         *
         * @param hexa mode code in hexa
         * @return mode
         */
        public static EposMode getMode(String hexa) {
            EposMode[] modes = EposMode.values();
            EposMode eposMode = null;            
            for (EposMode mode : modes) {
                if (mode.getModeInHexa().equalsIgnoreCase(hexa)) {
                    eposMode = mode;
                }
            }
            if (eposMode == null) {
                throw new IllegalArgumentException(hexa + ": this mode doesn't exist in CanOpenEpos.EposMode ENUM");
            } else return eposMode;
        }
    }

}
