/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

public class StatusDataPublishedByCarousel {
    private static final long serialVersionUID = 7037058370873652888L;
    private double rotationInDegrees;
    private boolean isLocked;
    private String[] filterNames;
    private String filterInStandbyName;
    private String actuatorXminusState;
    private String actuatorXplusState;

    private StatusDataPublishedByCarousel() {
    }

    public StatusDataPublishedByCarousel(int nbSockets) {
        this.rotationInDegrees = 0.0;
        this.isLocked = false;
        this.filterNames = new String[nbSockets];
        int i = 0;
        while (i < this.filterNames.length) {
            this.filterNames[i] = "";
            ++i;
        }
        this.filterInStandbyName = "none";
        this.actuatorXminusState = null;
        this.actuatorXplusState = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Carousel POSITION = ");
        sb.append(this.rotationInDegrees);
        sb.append("; carousel is locked=");
        sb.append(this.isLocked);
        sb.append("; Filters on carousel: ");
        int i = 0;
        while (i < this.filterNames.length) {
            if (this.filterNames[i].matches("empty")) {
                sb.append("socket ");
                sb.append(i);
                sb.append(" is empty;");
            } else {
                sb.append(this.filterNames[i]);
                sb.append(" is on socket number ");
                sb.append(i);
                sb.append(";");
            }
            ++i;
        }
        sb.append("/ Filter in Standby position= ");
        sb.append(this.filterInStandbyName).append(" /");
        return sb.toString();
    }

    public String getFilterInStandbyName() {
        return this.filterInStandbyName;
    }

    public String getFilterName(int index) {
        return this.filterNames[index];
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public double getRotationInDegrees() {
        return this.rotationInDegrees;
    }

    public String getActuatorXminusState() {
        return this.actuatorXminusState;
    }

    public void setActuatorXminusState(String actuatorXminusState) {
        this.actuatorXminusState = actuatorXminusState;
    }

    public String getActuatorXplusState() {
        return this.actuatorXplusState;
    }

    public void setFilterInStandbyName(String filterInStandbyName) {
        this.filterInStandbyName = filterInStandbyName;
    }

    public void setFilterName(int index, String filterName) {
        this.filterNames[index] = filterName;
    }

    public void setRotationInDegrees(double rotationInDegrees) {
        this.rotationInDegrees = rotationInDegrees;
    }

    public void setActuatorXplusState(String actuatorXplusState) {
        this.actuatorXplusState = actuatorXplusState;
    }

    public boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }
}

