/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.config;

import java.io.Serializable;
import java.util.Map;

/**
 *
 * @author virieux
 */
public class EPOSControllerConfig implements Serializable{
    
    String name;
    
    /* Parameters */
    Map<String,Integer> paramsForHoming;   
    Map<String,Integer> paramsForProfilePosition;
    Map<String,Integer> paramsForCurrent;

    public EPOSControllerConfig(String name) {
        this.name = name;
    }
    
    

    public EPOSControllerConfig(String aName, 
            Map<String, Integer> paramsForHoming, 
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForCurrent) {
        this.name = aName;
        this.paramsForHoming = paramsForHoming;
        this.paramsForProfilePosition = paramsForProfilePosition;
        this.paramsForCurrent = paramsForCurrent;
    }

    public String getName() {
        return name;
    }
    
    

    public Map<String, Integer> getParamsForHoming() {
        return paramsForHoming;
    }

    public Map<String, Integer> getParamsForProfilePosition() {
        return paramsForProfilePosition;
    }

    public Map<String, Integer> getParamsForCurrent() {
        return paramsForCurrent;
    }

    public void setParamsForHoming(Map<String, Integer> paramsForHoming) {
        this.paramsForHoming = paramsForHoming;
    }

    public void setParamsForProfilePosition(Map<String, Integer> paramsForProfilePosition) {
        this.paramsForProfilePosition = paramsForProfilePosition;
    }

    public void setParamsForCurrent(Map<String, Integer> paramsForCurrent) {
        this.paramsForCurrent = paramsForCurrent;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(name);
        sb.append("paramsForCurrent=[");
        sb.append(mapToString(paramsForCurrent));
        sb.append("];paramsForProfilePosition=[");
        sb.append(mapToString(paramsForProfilePosition));
        sb.append("];paramsForHoming=[");
        sb.append(mapToString(paramsForHoming));
        sb.append("]");
        return sb.toString();
    }
    
    public static String mapToString(Map<String, Integer> paramsMap) {
        StringBuilder sb = new StringBuilder();
        if (paramsMap==null) return "null";
        for (Map.Entry<String,Integer> entry : paramsMap.entrySet()) {
            String paramName = entry.getKey();
            int configValue = entry.getValue().intValue(); 
            sb.append(paramName);
            sb.append(":");
            sb.append(configValue);
            sb.append(",");
        }
        return sb.toString();
    }
    
    
    
    
    
    
    
    
    
}
