/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.config;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;

/**
 *
 * @author virieux
 */
public class AutochangerConfig implements Serializable {
    
    boolean realHardware;
    CanOpenProxyConfig tcpProxyConfig;
    EPOSControllerConfig linearRailMasterControllerConfig;
    EPOSControllerConfig linearRailSlaveControllerConfig;
    EPOSControllerConfig latchXminusControllerConfig;
    EPOSControllerConfig latchXplusControllerConfig;
    EPOSControllerConfig onlineClampControllerConfig;
    AutochangerTrucksConfig trucksConfig;
    PlutoGatewayConfig gwConfig;

    public AutochangerConfig(boolean realHardware, CanOpenProxyConfig tcpProxyConfig) {
        this.realHardware = realHardware;
        this.tcpProxyConfig = tcpProxyConfig;
    }

    public boolean isRealHardware() {
        return realHardware;
    }

    public void setRealHardware(boolean realHardware) {
        this.realHardware = realHardware;
    }

    public CanOpenProxyConfig getTcpProxyConfig() {
        return tcpProxyConfig;
    }

    public void setTcpProxyConfig(CanOpenProxyConfig tcpProxyConfig) {
        this.tcpProxyConfig = tcpProxyConfig;
    }

    public EPOSControllerConfig getLinearRailMasterControllerConfig() {
        return linearRailMasterControllerConfig;
    }

    public void setLinearRailMasterControllerConfig(EPOSControllerConfig linearRailMasterControllerConfig) {
        this.linearRailMasterControllerConfig = linearRailMasterControllerConfig;
    }

    public EPOSControllerConfig getLinearRailSlaveControllerConfig() {
        return linearRailSlaveControllerConfig;
    }

    public void setLinearRailSlaveControllerConfig(EPOSControllerConfig linearRailSlaveControllerConfig) {
        this.linearRailSlaveControllerConfig = linearRailSlaveControllerConfig;
    }
    
    

    public EPOSControllerConfig getOnlineClampControllerConfig() {
        return onlineClampControllerConfig;
    }

    public EPOSControllerConfig getLatchXminusControllerConfig() {
        return latchXminusControllerConfig;
    }

    public void setLatchXminusControllerConfig(EPOSControllerConfig latchXminusControllerConfig) {
        this.latchXminusControllerConfig = latchXminusControllerConfig;
    }

    public EPOSControllerConfig getLatchXplusControllerConfig() {
        return latchXplusControllerConfig;
    }

    public void setLatchXplusControllerConfig(EPOSControllerConfig latchXplusControllerConfig) {
        this.latchXplusControllerConfig = latchXplusControllerConfig;
    }

    public void setOnlineClampControllerConfig(EPOSControllerConfig onlineClampControllerConfig) {
        this.onlineClampControllerConfig = onlineClampControllerConfig;
    }

    public PlutoGatewayConfig getGwConfig() {
        return gwConfig;
    }

    public void setGwConfig(PlutoGatewayConfig gwConfig) {
        this.gwConfig = gwConfig;
    }
    
    

    public AutochangerTrucksConfig getTrucksConfig() {
        return trucksConfig;
    }

    public void setTrucksConfig(AutochangerTrucksConfig trucksConfig) {
        this.trucksConfig = trucksConfig;
    }


    
    
    
    
    
}
