/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.AutoChangerTrucksLocation;

/**
 * 
 * A structure for the data published on the status bus by a BasicAutoChangerModule.
 * 
 * @author virieux
 * 
 */

public class StatusDataPublishedByBasicAutoChanger {

    private static final long serialVersionUID = 1L;
    private String name;
    private String filterOnTrucksName;
    private boolean trucksEmpty;
    private AutoChangerTrucksLocation trucksLocation;
    private int railSensorStandbackXminusValue;
    private int railSensorStandbackXplusValue;
    private int railSensorStandbyXminusValue;
    private int railSensorStandbyXplusValue;
    private boolean movingToStandby;
    private boolean movingToStandback;


    public StatusDataPublishedByBasicAutoChanger() {
      
        this.name = "unknown";
	this.filterOnTrucksName = "none";
        this.trucksEmpty = true;
        this.trucksLocation = AutoChangerTrucksLocation.UNKNOWN;
        this.railSensorStandbackXminusValue = 0;
        this.railSensorStandbackXplusValue = 0;
        this.railSensorStandbyXminusValue = 0;
        this.railSensorStandbyXplusValue = 0;  
        this.movingToStandback = false;
        this.movingToStandby = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(name);
        sb.append(" / Filter on trucks = ");
        sb.append(this.filterOnTrucksName);
        //sb.append(" / trucks are at ").append(trucksLocation.toString());
        sb.append(" / isEmpty= ").append(trucksEmpty);
        sb.append(" / railSensorStandbackXminusValue= ").append(railSensorStandbackXminusValue);
        sb.append(" / railSensorStandbackXplusValue= ").append(railSensorStandbackXplusValue);
        sb.append(" / railSensorStandbyXminusValue= ").append(railSensorStandbyXminusValue);
        sb.append(" / railSensorStandbyXplusValue= ").append(railSensorStandbyXplusValue);
        if (movingToStandby)
            sb.append(" TRUCKS ARE MOVING TO STANDBY");
        else if (movingToStandback)
            sb.append(" TRUCKS ARE MOVING TO STANDBACK");
        return sb.toString();
    }

    public String getFilterOnTrucksName() {
        return filterOnTrucksName;
    }

    public void setFilterOnTrucksName(String filterOnTrucksName) {
        this.filterOnTrucksName = filterOnTrucksName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTrucksEmpty() {
        return trucksEmpty;
    }

    public void setTrucksEmpty(boolean trucksEmpty) {
        this.trucksEmpty = trucksEmpty;
    }

    public AutoChangerTrucksLocation getTrucksLocation() {
        return trucksLocation;
    }

    public void setTrucksLocation(AutoChangerTrucksLocation trucksLocation) {
        this.trucksLocation = trucksLocation;
    }

    public int getRailSensorStandbackXminusValue() {
        return railSensorStandbackXminusValue;
    }

    public void setRailSensorStandbackXminusValue(int railSensorStandbackXminusValue) {
        this.railSensorStandbackXminusValue = railSensorStandbackXminusValue;
    }

    public int getRailSensorStandbackXplusValue() {
        return railSensorStandbackXplusValue;
    }

    public void setRailSensorStandbackXplusValue(int railSensorStandbackXplusValue) {
        this.railSensorStandbackXplusValue = railSensorStandbackXplusValue;
    }

    public int getRailSensorStandbyXminusValue() {
        return railSensorStandbyXminusValue;
    }

    public void setRailSensorStandbyXminusValue(int railSensorStandbyXminusValue) {
        this.railSensorStandbyXminusValue = railSensorStandbyXminusValue;
    }

    public int getRailSensorStandbyXplusValue() {
        return railSensorStandbyXplusValue;
    }

    public void setRailSensorStandbyXplusValue(int railSensorStandbyXplusValue) {
        this.railSensorStandbyXplusValue = railSensorStandbyXplusValue;
    }

    public boolean isMovingToStandback() {
        return movingToStandback;
    }

    public void setMovingToStandback(boolean movingToStandback) {
        this.movingToStandback = movingToStandback;
    }

    public boolean isMovingToStandby() {
        return movingToStandby;
    }

    public void setMovingToStandby(boolean movingToStandby) {
        this.movingToStandby = movingToStandby;
    }



    



}
