/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 * The data published on the Status Bus by a latch.
 * A latch is what holds a filter on an autochanger truck.
 * 
 * @author virieux
 */

public class StatusDataPublishedByAutochangerLatch  {
    String name;
    private int lockSensorValue;
    private int unlockSensorValue;
    private int filterPresenceSensorValue;
    private String lockStatus;
    private boolean inError;
    private boolean controllerInFault;
    
    //TODO update controllerInFault
    
    public StatusDataPublishedByAutochangerLatch() {
        name = "unknown latch";
        lockSensorValue = 0;
        unlockSensorValue = 1;
        filterPresenceSensorValue = 0;
        lockStatus = "unknown";
        controllerInFault = false;
    }

    public int getFilterPresenceSensorValue() {
        return filterPresenceSensorValue;
    }

    public void setFilterPresenceSensorValue(int filterPositionSensorValue) {
        this.filterPresenceSensorValue = filterPositionSensorValue;
    }

    public String getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(String lockStatus) {
        this.lockStatus = lockStatus;
    }


    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(int unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }

    public boolean isInError() {
        return inError;
    }

    public void setInError(boolean inError) {
        this.inError = inError;
    }
    
    

    public boolean isControllerInFault() {
        return controllerInFault;
    }

    public void setControllerInFault(boolean controllerInFault) {
        this.controllerInFault = controllerInFault;
    }
    
    
    
   @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("latch ");
        sb.append(name).append(" / state= ").append(lockStatus);    
        sb.append(" / filterPositionSensorValue= ").append(filterPresenceSensorValue);
        sb.append(" / unlockSensorValue= ").append(this.unlockSensorValue);
        sb.append(" / lockSensorValue= ").append(this.lockSensorValue);
        sb.append(" / controllerInFault= ").append(this.controllerInFault);
        return sb.toString();
    }




    
    
    
    
}
