/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 *
 * @author turri
 */
public class FcsEnumerations {

    /* On which part of the FilterChanger the filter can be.*/
    public enum FilterLocation {
	ONCAROUSEL, ONAUTOCHANGER, ONLOADER, OUT, UNKNOWN
    }
    
    /**
     * The different possibilities for a carousel clamp
     * within the presence of a filter :
     *  - no filter
     *  - filter engaged and lockable
     *  - unknown state
     *  - sensor in error
     * The different possibilities for a latch in the autochanger
     * within the presence of a filter :
     *  - no filter
     *  - filter engaged
     *  - unknown state
     **/
    public enum FilterPresenceStatus {
        NOFILTER, ENGAGED, LOCKABLE, NOT_LOCKABLE, ERROR, UNKNOWN,    
    }
    
    /* For the autochanger in single-filter-test*/
    @Deprecated
    public enum FilterPresenceInLatchStatus {
        NOFILTER, ENGAGED, UNKNOWN, ERROR,
    }
    
    /* Used for the loader clamp and autochanger latches*/
    public enum LockStatus {
        UNLOCKED, 
        LOCKED, 
        UNKNOWN, 
        ERROR,   //when the clamp is locked and unlocked
        CLAMPED, //use for the loader Clamp
        INTRAVEL, //when the clamp is neither locked, nor locked
    }
    
        
    public enum AutoChangerTrucksLocation {
        STANDBY, STANDBACK, HANDOFF, ONLINE, UNKNOWN, ERROR, 
    }
    
    public enum LoaderCarrierLocation {
        STORAGE, HANDOFF, UNKNOWN, ERROR
    }
    
    /*For the carousel clamp*/
    public enum FilterClampState {
        READYTOCLAMP ("READY TO CLAMP"),
        UNCLAMPEDONFILTER ("UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY("UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER ("CLAMPED ON FILTER"),
        UNDEFINED ("UNDEFINED"),
        ERROR("IN ERROR");
        
        private final String tostring;
        
        FilterClampState(String aString) {
            this.tostring = aString;
        }
        @Override
        public String toString() { return tostring; }
    }
    
    /*Used for the rotation of the carousel*/
    public enum RunningWay {
	POSITIVE, NEGATIVE
    }
    
    
    /**
     * This is the different actions that can be made by a MobileItemModule.
     * For each of these actions, there is 3 String fields to define, they are messages
     * that are displayed at the console in Engineering mode or in the Tracer, and log BUS:
     * 1-when doing the action
     * 2-when the action is completed with success,
     * 3-when the action couldn't be completed.
     */
    public enum MobileItemAction {
        /*CAROUSEL ACTIONS*/
        //actions for the carousel clamps
        UNLOCK ("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE ("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),

        
        UNLOCKCLAMPS ("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASECLAMPS ("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        /*END OF CAROUSEL ACTIONS*/
        
        /*AUTOCHANGER ACTIONS*/
        //actions for the autochanger latches
        OPEN("OPENING LATCH", "IS OPEN", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        
        OPENLATCHES ("OPENING LATCHES AT STANDBY", "LATCHES ARE OPEN", "COULD NOT OPEN LATCHES"),
        CLOSELATCHES ("CLOSING LATCHES AT STANDBY", "LATCHES ARE CLOSED", "COULD NOT CLOSE LATCHES"),
        
        UNLOCK_ONLINECLAMP ("UNLOCKING ONLINECLAMP", "IS UNLOCKED", "COULD NOT UNLOCK ONLINECLAMP"),
        LOCK_ONLINECLAMP ("LOCKING ONLINECLAMP", "IS LOCKED", "COULD NOT LOCK ONLINECLAMP"),
        
        MOVE_TO_ABSOLUTE_POSITION("MOVING TO ABSOLUTE POSITION", "ABSOLUTE POSITION REACHED", 
                "COULD NOT MOVE TO ABSOLUTE POSITION"),
        MOVE_TO_RELATIVE_POSITION("MOVING TO RELATIVE POSITION", "RELATIVE POSITION REACHED", 
                "COULD NOT MOVE TO RELATIVE POSITION"),
        /*END OF AUTOCHANGER ACTIONS*/
        
        /*LOADER ACTIONS*/
        //actions of the loader clamp
        GOTOCLAMPEDPOSITION("LOADER CLAMP IS GOING TO CLAMPED POSITION", "HOOKS ARE AT CLAMPED POSITION", "COULD NOT GO TO CLAMPED POSITION"),
        GOTOHOMEPOSITION("LOADER CLAMP IS GOING TO HOME POSITION", "HOOKS ARE AT HOME POSITION", "COULD NOT GO TO HOME POSITION"),
        
        OPENLOADERHOOKS("OPENING LOADER HOOKS","LOADER HOOKS ARE OPEN","COULD NOT OPEN LOADER HOOKS"),
        CLOSELOADERHOOKS("CLOSING LOADER HOOKS","LOADER HOOKS ARE CLOSED","COULD NOT CLOSE LOADER HOOKS"),
        CLAMPLOADERHOOKS("CLAMPING LOADER HOOKS","LOADER HOOKS ARE CLAMPED","COULD NOT CLAMP LOADER HOOKS"),
        
        //actions of the loader carrier
        MOVELOADERCARRIERTOSTORAGE("MOVING LOADER CARRIER TO STORAGE","LOADER CARRIER IS AT STORAGE POSITION","COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVELOADERCARRIERTOHANDOFF("MOVING LOADER CARRIER TO HANDOFF","LOADER CARRIER IS AT HANDOFF POSITION","COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION");
        /*END OF LOADER ACTIONS*/
       
        private final String tostring;
        private final String doneString;
        private final String failureMsg;
        
        
        MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.tostring = aString;
            this.doneString = aDoneString;
            this.failureMsg = aFailureMsg;
        }
        @Override
        public String toString() { return tostring; }
        
        public String doneString () { return doneString; }
        
        public String getFailureMsg() {
            return failureMsg;
        }
    }
    


    
    
}
