/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.loader.config;

import java.io.Serializable;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;

/**
 *
 * @author virieux
 */
public class LoaderConfig implements Serializable {
    
    boolean realHardware;
    CanOpenProxyConfig tcpProxyConfig;
    LoaderClampConfig loaderClampConfig;
    LoaderCarrierConfig loaderCarrierConfig;
    EPOSControllerConfig loaderClampControllerConfig;
    EPOSControllerConfig loaderCarrierControllerConfig;

    public LoaderConfig(boolean realHardware,
            LoaderClampConfig loaderClampConfig, 
            LoaderCarrierConfig loaderCarrierConfig,
            CanOpenProxyConfig tcpProxyConfig) {
        this.realHardware = realHardware;
        this.loaderClampConfig = loaderClampConfig;
        this.loaderCarrierConfig = loaderCarrierConfig;
        this.tcpProxyConfig = tcpProxyConfig;
        
    }
    
    public void setLoaderClampConfig(LoaderClampConfig loaderClampConfig) {
        this.loaderClampConfig = loaderClampConfig;
    }

    public void setLoaderCarrierConfig(LoaderCarrierConfig loaderCarrierConfig) {
        this.loaderCarrierConfig = loaderCarrierConfig;
    }
    
    public void setLoaderClampControllerConfig(EPOSControllerConfig loaderClampCtlConfig) {
        this.loaderClampControllerConfig = loaderClampCtlConfig;
    }

    public void setLoaderCarrierControllerConfig(EPOSControllerConfig loaderCarrierCtlConfig) {
        this.loaderCarrierControllerConfig = loaderCarrierCtlConfig;
    }
    
    

    public boolean isRealHardware() {
        return realHardware;
    }
    

    public LoaderClampConfig getLoaderClampConfig() {
        return loaderClampConfig;
    }

    public LoaderCarrierConfig getLoaderCarrierConfig() {
        return loaderCarrierConfig;
    }

    public CanOpenProxyConfig getTcpProxyConfig() {
        return tcpProxyConfig;
    }

    public EPOSControllerConfig getLoaderClampControllerConfig() {
        return loaderClampControllerConfig;
    }

    public EPOSControllerConfig getLoaderCarrierControllerConfig() {
        return loaderCarrierControllerConfig;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LoaderConfig");
        return sb.toString();
    }
    
    


    
    
    
    
    
    
    
    
    
    
    
    
    
}
