/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.loader.config;

import java.io.Serializable;

/**
 * To initialize the GUI.
 * @author virieux
 */
public class LoaderCarrierConfig implements Serializable {
    
    private final String name;
    private final int handoffPosition;
    private final int storagePosition;
    private final int maxCurrent;
    private final int maxSpeed;
    private final long timeoutToGoToHandoff;
    private final long timeoutToGoToStorage;

    public LoaderCarrierConfig(String name, 
            int handoffPosition, 
            int storagePosition, 
            int maxCurrent, 
            int maxSpeed,
            long goToHandoffTimeout,
            long goToStorageTimeout
            ) {
        this.name = name;
        this.handoffPosition = handoffPosition;
        this.storagePosition = storagePosition;
        this.maxCurrent = maxCurrent;
        this.maxSpeed = maxSpeed;
        this.timeoutToGoToHandoff = goToHandoffTimeout;
        this.timeoutToGoToStorage = goToStorageTimeout;
    }
    




    public String getName() {
        return name;
    }

    public int getHandoffPosition() {
        return handoffPosition;
    }

    public int getStoragePosition() {
        return storagePosition;
    }

    public int getMaxCurrent() {
        return maxCurrent;
    }

    public int getMaxSpeed() {
        return maxSpeed;
    }
    
    
    
    
    
    
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("name");
        return sb.toString();
    }

    public long getTimeoutToGoToStorage() {
        return timeoutToGoToStorage;
    }

    public long getTimeoutToGoToHandoff() {
        return timeoutToGoToHandoff;
    }
    
    
    
}
