/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

/**
 * 
 * @author virieux
 */
public class StatusDataPublishedByLoaderCarrier extends StatusDataPublishedByFCS {
    
    int position;
    int ssiPosition;
    int speed;
    int current;
    int storageSensorValue0;
    int storageSensorValue1;
    int handoffSensorValue0;
    int handoffSensorValue1;
    boolean handoffInError;
    boolean storageInError;
    boolean controllerInError;
    
    private boolean limitSwitchDownInError;
    private boolean limitSwitchUpInError;

    public StatusDataPublishedByLoaderCarrier() {
    }
 
    public StatusDataPublishedByLoaderCarrier(String name, 
            int position, int ssiPosition, 
            int speed, int current,
            int storageSensorValue0, int storageSensorValue1, 
            int handoffSensorValue0, int handoffSensorValue1, 
            boolean handoffInError, boolean storageInError,
            boolean inError) {
        this.name = name;
        this.position = position;
        this.ssiPosition = ssiPosition;
        this.speed = speed;
        this.current = current;
        this.storageSensorValue0 = storageSensorValue0;
        this.storageSensorValue1 = storageSensorValue1;
        this.handoffSensorValue0 = handoffSensorValue0;
        this.handoffSensorValue1 = handoffSensorValue1;
        this.handoffInError = handoffInError;
        this.storageInError = storageInError;
        this.controllerInError = inError;
    }


    public int getPosition() {
        return position;
    }

    public int getSsiPosition() {
        return ssiPosition;
    }

    public boolean isStorageInError() {
        return storageInError;
    }

    public boolean isHandoffInError() {
        return handoffInError;
    }
    
    public int getSpeed() {
        return speed;
    }

    public int getCurrent() {
        return current;
    }

    public boolean isInError() {
        return controllerInError;
    }
    
    

    public int getStorageSensorValue0() {
        return storageSensorValue0;
    }

    public void setStorageSensorValue0(int storageSensorValue0) {
        this.storageSensorValue0 = storageSensorValue0;
    }

    public int getStorageSensorValue1() {
        return storageSensorValue1;
    }

    public void setStorageSensorValue1(int storageSensorValue1) {
        this.storageSensorValue1 = storageSensorValue1;
    }

    public int getHandoffSensorValue0() {
        return handoffSensorValue0;
    }

    public void setHandoffSensorValue0(int handoffSensorValue0) {
        this.handoffSensorValue0 = handoffSensorValue0;
    }

    public int getHandoffSensorValue1() {
        return handoffSensorValue1;
    }

    public void setHandoffSensorValue1(int handoffSensorValue1) {
        this.handoffSensorValue1 = handoffSensorValue1;
    }

    public boolean isControllerInError() {
        return controllerInError;
    }

    public void setControllerInError(boolean controllerInError) {
        this.controllerInError = controllerInError;
    }

    public boolean isLimitSwitchDownInError() {
        return limitSwitchDownInError;
    }

    public void setLimitSwitchDownInError(boolean limitSwitchDownInError) {
        this.limitSwitchDownInError = limitSwitchDownInError;
    }

    public boolean isLimitSwitchUpInError() {
        return limitSwitchUpInError;
    }

    public void setLimitSwitchUpInError(boolean limitSwitchUpInError) {
        this.limitSwitchUpInError = limitSwitchUpInError;
    }

   
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/position=");sb.append(position);
        sb.append("/ssiPosition=");sb.append(ssiPosition);
        sb.append("/speed=");sb.append(speed);
        sb.append("/current=");sb.append(current);
        sb.append("/storageSensorValue=");sb.append(storageSensorValue0);
        sb.append("/notAtStorageSensorValue=");sb.append(storageSensorValue1);
        sb.append("/storageSensorValue=");sb.append(storageSensorValue0);
        sb.append("/notAtStorageSensorValue=");sb.append(storageSensorValue1);
        sb.append("/handoffInError=");sb.append(handoffInError);
        sb.append("/storageInError=");sb.append(storageInError);
        sb.append("/controllerInError=");sb.append(controllerInError);
        //sb.append("/errorMessage=");sb.append(controllerErrorMessage);
        return sb.toString();
    }




    
    
    
    
    

    
}
