/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

import java.beans.ConstructorProperties;

/**
 * 
 * A structure for the data published on the status bus by the ClampModule.
 * 
 * @author virieux
 * 
 */

public class StatusDataPublishedByClamp extends StatusDataPublishedByFCS {

    private String clampState;
    private String filterPositionInClamp;
    private int filterPositionSensorValue;
    private String lockStatus;
    private int lockSensorValue;
    private double temperature;

    
    public StatusDataPublishedByClamp() {
        name = "unknown clamp";
        clampState = "unknown";
        filterPositionInClamp = "unknown";
        filterPositionSensorValue = 0;
        lockStatus = "unknown";
        lockSensorValue = 0;
        temperature = 0;
    }
    
    

    public void setFilterPositionInClamp(String filterPositionInClamp) {
        this.filterPositionInClamp = filterPositionInClamp;
    }

    public void setFilterPositionSensorValue(int filterPositionSensorValue) {
        this.filterPositionSensorValue = filterPositionSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public void setLockStatus(String lockStatus) {
        this.lockStatus = lockStatus;
    }


    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public double getTemperature() {
        return temperature;
    }
    
    public String getFilterPositionInClamp() {
        return filterPositionInClamp;
    }

    public int getFilterPositionSensorValue() {
        return filterPositionSensorValue;
    }

    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public String getLockStatus() {
        return lockStatus;
    }
    
    public String getClampState() {
        return clampState;
    }

    public void setClampState(String clampState) {
        this.clampState = clampState;
    }
    
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" / state= ").append(clampState);    
        sb.append(" / filterPositionInClamp= ").append(filterPositionInClamp);
        sb.append(" / filterPositionSensorValue= ").append(filterPositionSensorValue);
        sb.append(" / lockStatus= ").append(lockStatus);
        sb.append(" / lockSensorValue= ").append(lockSensorValue);
        return sb.toString();
    }

}
