package org.lsst.ccs.subsystems.fcs;

/**
 * 
 * A structure for the data published on the status bus by the AutoChangerModule.
 * 
 * A constructor with no parameter must be provided.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByAutoChanger extends StatusDataPublishedByFCS {

    private static final long serialVersionUID = 1L;
    int loaderConnectedSensorValue0;
    int loaderConnectedSensorValue1;
    boolean loaderConnectedSensorsInError;


    public int getLoaderConnectedSensorValue0() {
        return loaderConnectedSensorValue0;
    }

    public void setLoaderConnectedSensorValue0(int loaderConnectedSensorValue0) {
        this.loaderConnectedSensorValue0 = loaderConnectedSensorValue0;
    }

    public int getLoaderConnectedSensorValue1() {
        return loaderConnectedSensorValue1;
    }

    public void setLoaderConnectedSensorValue1(int loaderConnectedSensorValue1) {
        this.loaderConnectedSensorValue1 = loaderConnectedSensorValue1;
    }

    public boolean isLoaderConnectedSensorsInError() {
        return loaderConnectedSensorsInError;
    }

    public void setLoaderConnectedSensorsInError(boolean loaderConnectedSensorsInError) {
        this.loaderConnectedSensorsInError = loaderConnectedSensorsInError;
    }    

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("loaderConnected sensor in error=").append(loaderConnectedSensorValue0 ==1);
        sb.append("loader connected=").append(loaderConnectedSensorsInError);
        return sb.toString();
    }


}
