/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs;

/**
 *
 * @author virieux
 */
public class StatusDataPublishedByCanOpenProxy {
    
    String name;
    Object[][] hardwareList;

    public StatusDataPublishedByCanOpenProxy() {
    }
    
    public StatusDataPublishedByCanOpenProxy(int hardwareNB) {
        this.hardwareList = new Object[hardwareNB][5];
    }

    public StatusDataPublishedByCanOpenProxy(Object[][] otherList) {
        this.hardwareList = otherList;
    }
    
    

    public Object[][] getHardwareList() {
        return hardwareList;
    }

    public void setName(String name) {
        this.name = name;
    }
    
    
    
    public void setHardwareListLength(int length) {
        this.hardwareList = new Object[length][5];
    }
    
    public void addHardwareAtIndex(int index, String name, String nodeID, String serialNB, boolean booted, boolean initialized) {
        Object[] hardware = new Object[5];
        hardware[0] = name;
        hardware[1] = nodeID;
        hardware[2] = serialNB;
        hardware[3] = booted;
        hardware[4] = initialized;
        hardwareList[index] = hardware;        
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/hardware list length=");sb.append(this.hardwareList.length);
        for (int i=0; i<this.hardwareList.length; i++) {
            sb.append("\n");
            sb.append("/hardware name=");sb.append(hardwareList[i][0]);
            sb.append("/node ID=");sb.append(hardwareList[i][1]);
            sb.append("/serial number=");sb.append(hardwareList[i][2]);
            sb.append("/isBooted=");sb.append(hardwareList[i][3]);
            sb.append("/isInitialized=");sb.append(hardwareList[i][4]);           
        }
        sb.append("\n");
        
        return sb.toString();
    }
    
    public static void main(String[] args) {  
        StatusDataPublishedByCanOpenProxy s = new StatusDataPublishedByCanOpenProxy();
        s.setName("tcpProxyToTest");
        s.setHardwareListLength(6);
        s.addHardwareAtIndex(0, "plutoGateway", "1", "22d6", true, false);
        s.addHardwareAtIndex(1, "hooksController", "1b", "79007141", false, false);
        s.addHardwareAtIndex(2, "carrierController", "1a", "80003184", true, true);
        s.addHardwareAtIndex(3, "node4", "30", "BXDkfkf453R", true, false);
        s.addHardwareAtIndex(4, "node5", "7F", "BXksD453R", true, false);
        s.addHardwareAtIndex(5, "node6", "7F", "XC34553R", true, false);
        System.out.println("CANopen proxy status=" + s.toString());
    }
    
    
    
    
    
}
