/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.errors;

/**
 * Throwned when we received an emergency message for a node.
 * @author virieux
 */
public class CanOpenException extends FcsHardwareException {
    
    /**
     * Node ID of the node in error in hexa.
     */
    String nodeID;
    String errCode;
    


    /**
     * Creates a new instance of <code>CanOpenError</code> without detail message.
     */
    public CanOpenException() {
    }

    /**
     * Constructs an instance of <code>CanOpenError</code> with the specified detail message.
     * @param msg the detail message.
     */
    public CanOpenException(String msg) {
        super(msg);
    }
    
    public CanOpenException(String msg, String nodeID, String errCode) {
        super(msg);
        this.nodeID = nodeID;
        this.errCode = errCode;
    }
    
    public void setErrCode(String errCode) {
        this.errCode = errCode;
        
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" ERROR FOR NODE ID=").append(this.nodeID);
        sb.append(" CAN OPEN ERROR CODE=").append(this.errCode);
        return sb.toString();
    }
}
