/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.errors;

/**
 * A generic hardware error.
 * @author virieux
 */
public class HardwareException extends Exception {

     /**
     * Name of the hardware
     */
    String hardwareName;

    public HardwareException() {
        super("An hardware error has been detected.");
    }
    
     /**
     * Constructs an instance of <code>HardwareError</code> with the specified detail message.
     * @param msg the detail message.
     */
    public HardwareException(String msg) {
        super(msg);
    }
    
    /**
     * Constructs an instance of <code>HardwareError</code> with the specified detail message and
     * the name of the hardware in error.
     * @param msg
     * @param name 
     */
    public HardwareException(String msg, String name) {
        super(msg);
        this.hardwareName = name;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (!(this.hardwareName==null)) sb.append(" /Hardware in error: ").append(hardwareName);
        sb.append(this.getMessage());
        return sb.toString();
    }

}
