/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 *
 * @author turri
 */
public class FcsEnumerations {
    
    /**
     * Here are the different possibilities for a clamp within the presence of 
     * a filter :
     *  - no filter
     *  - filter engaged and lockable
     *  - unknown state
     *  - sensor in error
     **/
    public enum FilterPresenceStatus {
        NOFILTER, LOCKABLE, NOT_LOCKABLE, ERROR    
    }
    
    public enum FilterPresenceInLatchStatus {
        NOFILTER, ENGAGED, UNKNOWN, ERROR,
    }
    
    public enum LockStatus {
        UNLOCKED, LOCKED, UNKNOWN, ERROR, CLAMPED,
    }
    
        
    public enum AutoChangerTrucksLocation {
        STANDBY, STANDBACK, HANDOFF, ONLINE, UNKNOWN, ERROR, 
    }
    
    public enum LoaderCarrierLocation {
        STORAGE, HANDOFF, UNKNOWN, ERROR
    }
    
    public enum FilterClampState {
        READYTOCLAMP ("READY TO CLAMP"),
        UNCLAMPEDONFILTER ("UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY("UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER ("CLAMPED ON FILTER"),
        UNDEFINED ("UNDEFINED"),
        ERROR("IN ERROR");
        
        private final String tostring;
        
        FilterClampState(String aString) {
            this.tostring = aString;
        }
        @Override
        public String toString() { return tostring; }
    }
    
    
    /**
     * This is the different actions that can be made by a MobileItemModule.
     * For each of these actions, there is 3 String fields to define, they are messages
     * that are displayed at the console in Engineering mode or in the Tracer, and log BUS:
     * 1-when doing the action
     * 2-when the action is completed with success,
     * 3-when the action couldn't be completed.
     */
    public enum MobileItemAction {
        UNLOCK ("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE ("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        
        UNLOCKCLAMPS ("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASECLAMPS ("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        
        OPEN("OPENING LATCH", "IS OPEN", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        
        OPENLATCHES ("OPENING LATCHES AT STANDBY", "LATCHES ARE OPEN", "COULD NOT OPEN LATCHES"),
        CLOSELATCHES ("CLOSING LATCHES AT STANDBY", "LATCHES ARE CLOSED", "COULD NOT CLOSE LATCHES"),
        
        GOTOCLOSEPOSITION("LOADER CLAMP IS GOING TO CLOSE POSITION", "HOOKS ARE AT CLOSE POSITION", "COULD NOT GO TO CLOSE POSITION"),
        GOTOHOMEPOSITION("LOADER CLAMP IS GOING TO HOME POSITION", "HOOKS ARE AT HOME POSITION", "COULD NOT GO TO HOME POSITION"),
        
        OPENHOOK("OPENING HOOK","IS OPEN","COULD NOT OPEN HOOK"),
        CLOSEHOOK("CLOSING HOOK","IS CLOSED","COULD NOT CLOSE HOOK"),
        
        OPENLOADERHOOKS("OPENING LOADER HOOKS","LOADER HOOKS ARE OPEN","COULD NOT OPEN LOADER HOOKS"),
        CLOSELOADERHOOKS("CLOSING LOADER HOOKS","LOADER HOOKS ARE CLOSED","COULD NOT CLOSE LOADER HOOKS"),
        CLAMPLOADERHOOKS("CLOSING LOADER HOOKS STRONGLY","LOADER HOOKS ARE CLOSED STRONGLY","COULD NOT CLOSE LOADER HOOKS STRONGLY"),
        
        MOVELOADERCARRIERTOSTORAGE("MOVING LOADER CARRIER TO STORAGE","LOADER CARRIER IS AT STORAGE POSITION","COULD NOT MOVE LOADER CARRIER TO STORAGE POSITION"),
        MOVELOADERCARRIERTOHANDOFF("MOVING LOADER CARRIER TO HANDOFF","LOADER CARRIER IS AT HANDOFF POSITION","COULD NOT MOVE LOADER CARRIER TO HANDOFF POSITION");
        
       
        private final String tostring;
        private final String doneString;
        private final String failureMsg;
        
        
        MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.tostring = aString;
            this.doneString = aDoneString;
            this.failureMsg = aFailureMsg;
        }
        @Override
        public String toString() { return tostring; }
        
        public String doneString () { return doneString; }
        
        public String getFailureMsg() {
            return failureMsg;
        }
    }

    
    
}
