package org.lsst.ccs.subsystems.fcs;

/**
 * 
 * A structure for the data published on the status bus by the AutoChangerModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByAutoChanger extends StatusDataPublishedByBasicAutoChanger {

    private static final long serialVersionUID = 1L;
    private boolean isLockedOnlineClamp;

    public StatusDataPublishedByAutoChanger() {
        super();
        this.isLockedOnlineClamp = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" / Online Clamp = ");
        if (isLockedOnlineClamp) {
            sb.append("LOCKED");
        } else {
            sb.append("UNLOCKED");
        }
        return sb.toString();
    }

    public boolean isIsLockedOnlineClamp() {
        return isLockedOnlineClamp;
    }

    public void setIsLockedOnlineClamp(boolean isLockedOnlineClamp) {
        this.isLockedOnlineClamp = isLockedOnlineClamp;
    }
}
