package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.Status;

/**
 * 
 * A structure for the data published on the status bus by the CarouselModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByCarousel extends Status {

    private static final long serialVersionUID = 7037058370873652888L;
    private double rotationInDegrees;
    private boolean isLocked;
    private String[] filterNames;
    private String filterInStandbyName;
    private String[] clampsInfo;
    private String actuatorXminusState;
    private String actuatorXplusState;

    public StatusDataPublishedByCarousel(int nbSockets) {
        rotationInDegrees = 0.0;
        isLocked = false;
        filterNames = new String[nbSockets];
        for (int i = 0; i < filterNames.length; i++) {
            filterNames[i] = "";
        }
        filterInStandbyName = "none";
        clampsInfo = new String[nbSockets];
        actuatorXminusState = null;
        actuatorXplusState = null;
    }

    @Override
    public String toString() {

        StringBuilder sb = new StringBuilder("Carousel POSITION = ");
        sb.append(this.rotationInDegrees);
        sb.append("; carousel is locked=");
        sb.append(this.isLocked);
        sb.append("; Filters on carousel: ");
        for (int i = 0; i < filterNames.length; i++) {
            //if (filterNames[i] == "empty") {
            if (filterNames[i].matches("empty")) {
                sb.append("socket ");
                sb.append(i);
                sb.append(" is empty;");
            } else {
                sb.append(filterNames[i]);
                sb.append(" is on socket number ");
                sb.append(i);
                sb.append(";");
            }
        }
        



        sb.append("/ Filter in Standby position= ");
        sb.append(this.filterInStandbyName).append(" /");

        for (int i = 0; i < clampsInfo.length; i++) {
            sb.append(clampsInfo[i]);
        }

        return sb.toString();
    }

    public String getFilterInStandbyName() {
        return filterInStandbyName;
    }

    public String getFilterName(int index) {
        return filterNames[index];
    }

    public boolean isLocked() {
        return isLocked;
    }

    public double getRotationInDegrees() {
        return rotationInDegrees;
    }

    public String getActuatorXminusState() {
        return actuatorXminusState;
    }

    public void setActuatorXminusState(String actuatorXminusState) {
        this.actuatorXminusState = actuatorXminusState;
    }

    public String getActuatorXplusState() {
        return actuatorXplusState;
    }

    public void setFilterInStandbyName(String filterInStandbyName) {
        this.filterInStandbyName = filterInStandbyName;
    }

    public void setFilterName(int index, String filterName) {
        this.filterNames[index] = filterName;
    }

    public void setRotationInDegrees(double rotationInDegrees) {
        this.rotationInDegrees = rotationInDegrees;
    }

    public void setActuatorXplusState(String actuatorXplusState) {
        this.actuatorXplusState = actuatorXplusState;
    }

    public String getClampsInfo(int index) {
        return clampsInfo[index];
    }

    public void setClampsInfo(int index, String clampInfo) {
        clampsInfo[index] = clampInfo;
    }

    public boolean isIsLocked() {
        return isLocked;
    }

    public void setIsLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }
}
