/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.Status;

/**
 * The data published on the Status Bus by a latch.
 * A latch is what holds a filter on an autochanger truck.
 * 
 * @author virieux
 */
public class StatusDataPublishedByLatch extends Status {
    String name;
    private int lockSensorValue;
    private int unlockSensorValue;
    private int filterPositionSensorValue;
    private String lockStatus;
    
    public StatusDataPublishedByLatch() {
        name = "unknown latch";
        lockSensorValue = 0;
        unlockSensorValue = 1;
        filterPositionSensorValue = 0;
        lockStatus = "unknown";
    }

    public int getFilterPositionSensorValue() {
        return filterPositionSensorValue;
    }

    public void setFilterPositionSensorValue(int filterPositionSensorValue) {
        this.filterPositionSensorValue = filterPositionSensorValue;
    }

    public String getLockStatus() {
        return lockStatus;
    }

    public void setLockStatus(String lockStatus) {
        this.lockStatus = lockStatus;
    }


    public int getLockSensorValue() {
        return lockSensorValue;
    }

    public void setLockSensorValue(int lockSensorValue) {
        this.lockSensorValue = lockSensorValue;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getUnlockSensorValue() {
        return unlockSensorValue;
    }

    public void setUnlockSensorValue(int unlockSensorValue) {
        this.unlockSensorValue = unlockSensorValue;
    }
    
   @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("latch ");
        sb.append(name).append(" / state= ").append(lockStatus);    
        sb.append(" / filterPositionSensorValue= ").append(filterPositionSensorValue);
        sb.append(" / unlockSensorValue= ").append(this.unlockSensorValue);
        sb.append(" / lockSensorValue= ").append(this.lockSensorValue);
        return sb.toString();
    }




    
    
    
    
}
