/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 *
 * @author turri
 */
public class FcsEnumerations {
    
    /**
     * Here are the different possibilities for a clamp within the presence of 
     * a filter :
     *  - no filter
     *  - filter engaged and lockable
     *  - unknown state
     *  - sensor in error
     **/
    public enum FilterPresenceStatus {
        NOFILTER, LOCKABLE, NOT_LOCKABLE, ERROR    
    }
    
    public enum FilterPresenceInLatchStatus {
        NOFILTER, ENGAGED, UNKNOWN, ERROR,
    }
    
    public enum LockStatus {
        UNLOCKED, LOCKED, UNKNOWN, ERROR
    }
    
    
    
    public enum FilterClampState {
        READYTOCLAMP ("READY TO CLAMP"),
        UNCLAMPEDONFILTER ("UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY("UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER ("CLAMPED ON FILTER"),
        UNDEFINED ("UNDEFINED"),
        ERROR("IN ERROR");
        
        private final String tostring;
        
        FilterClampState(String aString) {
            this.tostring = aString;
        }
        public String toString() { return tostring; }
    }
    
    public enum MobileItemAction {
        UNLOCK ("UNLOCKING CLAMP", "IS UNLOCKED", "COULD NOT UNLOCK CLAMP"),
        RELEASE ("RELEASING CLAMP", "IS RELEASED", "COULD NOT RELEASE CLAMP"),
        
        UNLOCKCLAMPS ("UNLOCKING CLAMPS", "CLAMPS ARE UNLOCKED", "COULD NOT UNLOCK CLAMPS"),
        RELEASECLAMPS ("RELEASING CLAMPS", "CLAMPS ARE RELEASED", "COULD NOT RELEASE CLAMPS"),
        
        OPEN("OPENING LATCH", "IS OPEN", "COULD NOT OPEN LATCH"),
        CLOSE("CLOSING LATCH", "IS CLOSED", "COULD NOT CLOSE LATCH"),
        
        OPENLATCHES ("OPENING LATCHES AT STANDBY", "LATCHES ARE OPEN", "COULD NOT OPEN LATCHES"),
        CLOSELATCHES ("CLOSING LATCHES AT STANDBY", "LATCHES ARE CLOSED", "COULD NOT CLOSE LATCHES");
       
        private final String tostring;
        private final String doneString;
        private final String failureMsg;
        
        
        MobileItemAction(String aString, String aDoneString, String aFailureMsg) {
            this.tostring = aString;
            this.doneString = aDoneString;
            this.failureMsg = aFailureMsg;
        }
        @Override
        public String toString() { return tostring; }
        
        public String doneString () { return doneString; }
        
        public String getFailureMsg() {
            return failureMsg;
        }
    }
    
    public enum AutoChangerTrucksLocation {
        STANDBY, STANDBACK, ONLINE, UNKNOWN, ERROR
    }
    
    
}
