/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

/**
 *
 * @author turri
 */
public class FcsEnumerations {
    
    /**
     * Here are the different possibilities for a clamp within the presence of 
     * a filter :
     *  - no filter
     *  - filter engaged and lockable
     *  - unknown state
     *  - sensor in error
     **/
    public enum FilterPresenceStatus {
        NOFILTER, LOCKABLE, NOT_LOCKABLE, ERROR    
    }
    
    public enum FilterPresenceInLatchStatus {
        NOFILTER, ENGAGED, UNKNOWN, ERROR,
    }
    
    public enum LockStatus {
        UNLOCKED, LOCKED, UNKNOWN, ERROR
    }
    
    
    
    public enum FilterClampState {
        READYTOCLAMP ("READY TO CLAMP"),
        UNCLAMPEDONFILTER ("UNCLAMPED ON FILTER"),
        UNCLAMPEDEMPTY("UNCLAMPED AND EMPTY"),
        CLAMPEDONFILTER ("CLAMPED ON FILTER"),
        UNDEFINED ("UNDEFINED"),
        ERROR("IN ERROR");
        
        private final String tostring;
        
        FilterClampState(String aString) {
            this.tostring = aString;
        }
        public String toString() { return tostring; }
    }
    
    public enum AutoChangerTrucksLocation {
        STANDBY, STANDBACK, ONLINE, UNKNOWN, ERROR
    }
    
    
}
