/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.bus.Status;

public class StatusDataPublishedByCarousel
extends Status {
    private static final long serialVersionUID = 7037058370873652888L;
    private double rotationInDegrees = 0.0;
    private boolean isLocked = false;
    private String[] filterNames;
    private String filterInStandbyName;
    private String[] clampsInfo;
    private String actuatorXminusState;
    private String actuatorXplusState;

    public StatusDataPublishedByCarousel(int nbSockets) {
        this.filterNames = new String[nbSockets];
        for (int i = 0; i < this.filterNames.length; ++i) {
            this.filterNames[i] = "";
        }
        this.filterInStandbyName = "none";
        this.clampsInfo = new String[nbSockets];
        this.actuatorXminusState = null;
        this.actuatorXplusState = null;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("Carousel POSITION = ");
        sb.append(this.rotationInDegrees);
        sb.append("; carousel is locked=");
        sb.append(this.isLocked);
        sb.append("; Filters on carousel: ");
        for (i = 0; i < this.filterNames.length; ++i) {
            if (this.filterNames[i].matches("empty")) {
                sb.append("socket ");
                sb.append(i);
                sb.append(" is empty;");
                continue;
            }
            sb.append(this.filterNames[i]);
            sb.append(" is on socket number ");
            sb.append(i);
            sb.append(";");
        }
        sb.append("/ Filter in Standby position= ");
        sb.append(this.filterInStandbyName).append(" /");
        for (i = 0; i < this.clampsInfo.length; ++i) {
            sb.append(this.clampsInfo[i]);
        }
        return sb.toString();
    }

    public String getFilterInStandbyName() {
        return this.filterInStandbyName;
    }

    public String getFilterName(int index) {
        return this.filterNames[index];
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public double getRotationInDegrees() {
        return this.rotationInDegrees;
    }

    public String getActuatorXminusState() {
        return this.actuatorXminusState;
    }

    public void setActuatorXminusState(String actuatorXminusState) {
        this.actuatorXminusState = actuatorXminusState;
    }

    public String getActuatorXplusState() {
        return this.actuatorXplusState;
    }

    public void setFilterInStandbyName(String filterInStandbyName) {
        this.filterInStandbyName = filterInStandbyName;
    }

    public void setFilterName(int index, String filterName) {
        this.filterNames[index] = filterName;
    }

    public void setRotationInDegrees(double rotationInDegrees) {
        this.rotationInDegrees = rotationInDegrees;
    }

    public void setActuatorXplusState(String actuatorXplusState) {
        this.actuatorXplusState = actuatorXplusState;
    }

    public String getClampsInfo(int index) {
        return this.clampsInfo[index];
    }

    public void setClampsInfo(int index, String clampInfo) {
        this.clampsInfo[index] = clampInfo;
    }

    public boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }
}

