package org.lsst.ccs.subsystems.fcs;

import java.io.Serializable;

/**
 * 
 * A structure for the data published on the status bus by the AutoChangerModule.
 * 
 * @author virieux
 * 
 */
public class StatusDataPublishedByAutoChanger extends StatusDataPublishedByBasicAutoChanger {

    private static final long serialVersionUID = 1L;
    private String flipRailState;
    private boolean isLockedOnlineClamp;

    public StatusDataPublishedByAutoChanger() {
        super();
        this.flipRailState = "unknown";
        this.isLockedOnlineClamp = false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());

        sb.append("\n Flip Rail State = ");
        sb.append(this.flipRailState);
        sb.append(" / Online Clamp = ");
        if (isLockedOnlineClamp) {
            sb.append("LOCKED");
        } else {
            sb.append("UNLOCKED");
        }
        return sb.toString();
    }

    public String getFlipRailState() {
        return flipRailState;
    }

    public void setFlipRailState(String flipRailState) {
        this.flipRailState = flipRailState;
    }

    public boolean isIsLockedOnlineClamp() {
        return isLockedOnlineClamp;
    }

    public void setIsLockedOnlineClamp(boolean isLockedOnlineClamp) {
        this.isLockedOnlineClamp = isLockedOnlineClamp;
    }
}
