/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.subsystem.doorman.main.DoorChannel;
import org.lsst.ccs.subsystem.doorman.main.DoorChannelType;
import org.lsst.ccs.subsystem.doorman.main.Instrument;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;
import org.lsst.ccs.subsystem.doorman.main.InstrumentStatus;
import org.lsst.ccs.subsystem.doorman.main.TrendableRecord;

public class ChilledDoor
implements Instrument {
    private final int index;
    private final boolean enabled;
    private final String hostname;
    private final Optional<HardwareException> lastExc;
    private final Optional<TrendableRecord> lastData;
    private final int excCount;
    private static final String LOCATION = "ir2/chilledDoor";

    public ChilledDoor(InstrumentConfig config) {
        this.index = config.index;
        this.enabled = false;
        this.hostname = config.conn;
        this.lastExc = Optional.empty();
        this.lastData = Optional.empty();
        this.excCount = 0;
    }

    private ChilledDoor(int index, boolean enabled, String hostname, Optional<HardwareException> exc, Optional<TrendableRecord> data, int excCount) {
        this.index = index;
        this.enabled = enabled;
        this.hostname = hostname;
        this.lastExc = exc;
        this.lastData = data;
        this.excCount = excCount;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastExc;
    }

    @Override
    public int getExceptionCount() {
        return this.excCount;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.lastData.map(Stream::of).orElseGet(Stream::empty);
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, LOCATION);
    }

    @Override
    public Instrument disable() {
        return new ChilledDoor(this.index, false, this.hostname, this.lastExc, this.lastData, this.excCount);
    }

    @Override
    public Instrument enable() {
        return new ChilledDoor(this.index, true, this.hostname, this.lastExc, this.lastData, 0);
    }

    @Override
    public Instrument read() {
        Instant now = Instant.now();
        Modbus door = new Modbus();
        HardwareException thisExc = null;
        try {
            door.open(0, this.hostname);
        }
        catch (DriverException exc) {
            thisExc = new HardwareException((Throwable)exc, thisExc);
        }
        HashMap<String, Serializable> channels = new HashMap<String, Serializable>();
        if (thisExc == null) {
            for (DoorChannel chan : DoorChannel.values()) {
                try {
                    short sval;
                    double chanval = 0.0;
                    if (chan.getType() == DoorChannelType.ANALOG) {
                        sval = door.readRegisters((short)0, (short)chan.getRegister(), (short)1)[0];
                        chanval = (double)sval / 10.0;
                    } else if (chan.getType() == DoorChannelType.INTEGER) {
                        sval = door.readRegisters((short)0, (short)chan.getRegister(), (short)1)[0];
                        chanval = sval;
                    } else {
                        byte cval = door.readCoils((short)0, (short)chan.getRegister(), (short)1)[0];
                        chanval = cval != 0 ? 1.0 : 0.0;
                    }
                    channels.put(chan.getKey(), Double.valueOf(chanval));
                }
                catch (DriverException exc) {
                    thisExc = new HardwareException((Throwable)exc, thisExc);
                }
            }
        }
        TrendableRecord msg = new TrendableRecord(LOCATION, now, channels);
        return new ChilledDoor(this.index, this.enabled, this.hostname, Optional.ofNullable(thisExc), Optional.of(msg), thisExc == null ? 0 : this.excCount + 1);
    }
}

