/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.doorman.main;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystem.doorman.main.ConfigurationService;
import org.lsst.ccs.subsystem.doorman.main.EmailDeliveryAlert;
import org.lsst.ccs.subsystem.doorman.main.Instrument;
import org.lsst.ccs.subsystem.doorman.main.InstrumentConfig;
import org.lsst.ccs.subsystem.doorman.main.InstrumentIOAlert;
import org.lsst.ccs.subsystem.doorman.main.InstrumentReport;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public final class DoormanMain
implements ClearAlertHandler,
HasLifecycle,
HardwareController,
SignalHandler {
    private ConfigurationService configService = null;
    private final CopyOnWriteArrayList<Instrument> instruments = new CopyOnWriteArrayList();
    private final Lock readoutLock;
    private PeriodicTask readoutTask = null;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.doorman");
    private static final int EXC_COUNT_ALERT_THRESHOLD = 15;

    @Command(type=Command.CommandType.QUERY, description="Displays a short report on instrument status.")
    public String instruments() {
        return new InstrumentReport(this.instruments).toString();
    }

    @Command(type=Command.CommandType.ACTION, description="Prevents further readout of an instrument")
    public String disable(@Argument(description="Instrument index number.") int index) throws Exception {
        return this.callIfNotBusy(() -> {
            Instrument ins = this.findInstrument(index);
            if (ins == null) {
                throw new IllegalArgumentException("No such instrument.");
            }
            this.instruments.set(ins.getIndex(), ins.disable());
            return "OK";
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Enables an instrument for readout.")
    public String enable(@Argument(description="Instrument index number.") int index) throws Exception {
        return this.callIfNotBusy(() -> {
            Instrument ins = this.findInstrument(index);
            if (ins == null) {
                throw new IllegalArgumentException("No such instrument.");
            }
            Instrument newIns = ins.enable();
            this.instruments.set(ins.getIndex(), newIns);
            if (newIns.getLastException().isPresent()) {
                throw newIns.getLastException().get();
            }
            return "OK";
        });
    }

    public TreeWalkerDiag signal(Signal sig) {
        if (sig.getLevel() == SignalLevel.STOP) {
            this.readoutTask.cancel(false);
        } else if (sig.getLevel() == SignalLevel.HALT) {
            this.readoutTask.cancel(true);
        }
        return TreeWalkerDiag.GO;
    }

    public DoormanMain() {
        this.readoutLock = new ReentrantLock();
    }

    public void init() {
        this.configService = (ConfigurationService)this.getSubsystem().getComponentLookup().getComponentByName("config");
        if (this.configService == null) {
            throw new Error("Missing ConfigurationService component.");
        }
    }

    public void start() {
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        this.readConfiguration();
        this.enableAllInstruments();
        this.scheduleFirstReadout(Duration.ZERO);
        return TreeWalkerDiag.GO;
    }

    private void readConfiguration() {
        List<InstrumentConfig> configs = this.configService.getInstrumentConfigs();
        List insts = configs.stream().map(cfg -> cfg.type.make((InstrumentConfig)cfg)).collect(Collectors.toList());
        this.instruments.addAll(insts);
    }

    private void enableAllInstruments() throws HardwareException {
        ArrayList exceptions = new ArrayList();
        this.instruments.forEach(inst -> {
            Instrument newIns = inst.enable();
            this.instruments.set(inst.getIndex(), newIns);
            newIns.getLastException().ifPresent(exc -> exceptions.add(exc));
        });
        if (exceptions.size() > 0) {
            HardwareException top = (HardwareException)exceptions.remove(0);
            for (HardwareException exc : exceptions) {
                top = new HardwareException(exc);
            }
            throw top;
        }
    }

    private void scheduleFirstReadout(Duration initialDelay) {
        this.readoutTask = this.getSubsystem().getScheduler().scheduleAtFixedRate(this::readoutTaskBody, initialDelay.getSeconds(), this.configService.getReadoutInterval().getSeconds(), TimeUnit.SECONDS);
    }

    private void readoutTaskBody() {
        try {
            this.readoutLock.lockInterruptibly();
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.instruments.stream().filter(ins -> ins.getStatus().enabled).forEach(ins -> {
                if (Thread.currentThread().isInterrupted()) {
                    throw new TerminationException();
                }
                this.readAndUpdate((Instrument)ins);
            });
        }
        catch (TerminationException exc) {
            this.log.warning((Object)"Instrument readout was interrupted!");
        }
        finally {
            this.readoutLock.unlock();
        }
    }

    private void readAndUpdate(Instrument ins) {
        Instrument newIns = ins.read();
        this.instruments.set(ins.getIndex(), newIns);
        this.checkForExceptionDuringReadout(newIns);
        newIns.getTrendables().forEach(msg -> msg.post(this.getSubsystem()));
        this.configService.updateInstrument(newIns.getStatus());
    }

    private void checkForExceptionDuringReadout(Instrument newIns) {
        String badloc = newIns.getStatus().location;
        if (newIns.getExceptionCount() > 0) {
            this.log.error((Object)(badloc + ": Readout error"), (Throwable)newIns.getLastException().get());
        }
        boolean alertExists = this.getSubsystem().getAlertService().getRaisedAlertSummary().getAlertState() != AlertState.NOMINAL;
        boolean tooManyExceptions = newIns.getExceptionCount() > 15;
        String cause = "Too long a run of readout problems";
        if (tooManyExceptions && !alertExists) {
            HardwareException exc = newIns.getLastException().get();
            this.getSubsystem().getAlertService().raiseAlert((Alert)new InstrumentIOAlert(), AlertState.WARNING, badloc + ": " + exc.getMessage());
            this.sendEmail("Too long a run of readout problems", exc.toString());
        }
    }

    public void checkStarted() throws HardwareException {
    }

    public void postStart() throws HardwareException {
    }

    public void checkStopped() throws HardwareException {
        this.readoutTask.cancel(false);
        if (!this.readoutTask.isCancelled()) {
            throw new HardwareException(false, "The readout task couldn't be cancelled.");
        }
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
    }

    private Instrument findInstrument(int index) {
        Instrument ins = null;
        try {
            ins = this.instruments.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ins;
    }

    private String callIfNotBusy(Callable<String> cmd) throws Exception {
        if (!this.readoutLock.tryLock()) {
            return "BUSY";
        }
        try {
            String string = cmd.call();
            return string;
        }
        finally {
            this.readoutLock.unlock();
        }
    }

    private void sendEmail(String subject, String message) {
        try {
            String[] recipients = this.configService.getEmailRecipients().toArray(new String[0]);
            if (recipients.length > 0) {
                SimpleEmail emsg = new SimpleEmail();
                emsg.setHostName(this.configService.getSMTPServer());
                emsg.setFrom(this.configService.getEmailSender());
                emsg.setBounceAddress(this.configService.getEmailBounceAddress());
                emsg.addReplyTo(this.configService.getEmailBounceAddress());
                emsg.setSubject("[Doorman] " + subject);
                emsg.setMsg(message);
                emsg.addTo(recipients);
                emsg.send();
            }
        }
        catch (EmailException exc) {
            String summary = "Error composing or sending email.";
            this.log.error((Object)"Error composing or sending email.", (Throwable)exc);
            this.getSubsystem().raiseAlert((Alert)new EmailDeliveryAlert(), AlertState.WARNING, "Error composing or sending email.");
        }
    }

    private static class TerminationException
    extends RuntimeException {
        private TerminationException() {
        }
    }
}

